/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ConflictException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DisassociateUserResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InternalServerException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ThrottlingException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsResponse;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ValidationException;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListIdentityProvidersPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListProductSubscriptionsPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators.ListUserAssociationsPublisher;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.AssociateUserRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.DeregisterIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.DisassociateUserRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListProductSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.ListUserAssociationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.RegisterIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.StartProductSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.StopProductSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.transform.UpdateIdentityProviderSettingsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultLicenseManagerUserSubscriptionsAsyncClient
implements LicenseManagerUserSubscriptionsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseManagerUserSubscriptionsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLicenseManagerUserSubscriptionsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateUserResponse> associateUser(AssociateUserRequest associateUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateUser").withMarshaller((Marshaller)new AssociateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$associateUser$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$associateUser$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterIdentityProviderResponse> deregisterIdentityProvider(DeregisterIdentityProviderRequest deregisterIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, deregisterIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterIdentityProviderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterIdentityProvider").withMarshaller((Marshaller)new DeregisterIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterIdentityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$deregisterIdentityProvider$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$deregisterIdentityProvider$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateUserResponse> disassociateUser(DisassociateUserRequest disassociateUserRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateUserResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateUser").withMarshaller((Marshaller)new DisassociateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$disassociateUser$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$disassociateUser$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listIdentityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityProvidersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityProviders").withMarshaller((Marshaller)new ListIdentityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIdentityProvidersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listIdentityProviders$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listIdentityProviders$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListIdentityProvidersPublisher listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest) {
        return new ListIdentityProvidersPublisher(this, this.applyPaginatorUserAgent(listIdentityProvidersRequest));
    }

    @Override
    public CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstancesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstances").withMarshaller((Marshaller)new ListInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listInstances$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listInstances$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        return new ListInstancesPublisher(this, this.applyPaginatorUserAgent(listInstancesRequest));
    }

    @Override
    public CompletableFuture<ListProductSubscriptionsResponse> listProductSubscriptions(ListProductSubscriptionsRequest listProductSubscriptionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listProductSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProductSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProductSubscriptionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProductSubscriptions").withMarshaller((Marshaller)new ListProductSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listProductSubscriptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listProductSubscriptions$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listProductSubscriptions$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListProductSubscriptionsPublisher listProductSubscriptionsPaginator(ListProductSubscriptionsRequest listProductSubscriptionsRequest) {
        return new ListProductSubscriptionsPublisher(this, this.applyPaginatorUserAgent(listProductSubscriptionsRequest));
    }

    @Override
    public CompletableFuture<ListUserAssociationsResponse> listUserAssociations(ListUserAssociationsRequest listUserAssociationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, listUserAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUserAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserAssociationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserAssociations").withMarshaller((Marshaller)new ListUserAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listUserAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listUserAssociations$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$listUserAssociations$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListUserAssociationsPublisher listUserAssociationsPaginator(ListUserAssociationsRequest listUserAssociationsRequest) {
        return new ListUserAssociationsPublisher(this, this.applyPaginatorUserAgent(listUserAssociationsRequest));
    }

    @Override
    public CompletableFuture<RegisterIdentityProviderResponse> registerIdentityProvider(RegisterIdentityProviderRequest registerIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterIdentityProviderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterIdentityProvider").withMarshaller((Marshaller)new RegisterIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerIdentityProviderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$registerIdentityProvider$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$registerIdentityProvider$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartProductSubscriptionResponse> startProductSubscription(StartProductSubscriptionRequest startProductSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, startProductSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartProductSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartProductSubscriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartProductSubscription").withMarshaller((Marshaller)new StartProductSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startProductSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$startProductSubscription$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$startProductSubscription$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopProductSubscriptionResponse> stopProductSubscription(StopProductSubscriptionRequest stopProductSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopProductSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopProductSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopProductSubscriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopProductSubscription").withMarshaller((Marshaller)new StopProductSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopProductSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$stopProductSubscription$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$stopProductSubscription$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateIdentityProviderSettingsResponse> updateIdentityProviderSettings(UpdateIdentityProviderSettingsRequest updateIdentityProviderSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerUserSubscriptionsAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateIdentityProviderSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager User Subscriptions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityProviderSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityProviderSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityProviderSettings").withMarshaller((Marshaller)new UpdateIdentityProviderSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateIdentityProviderSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$updateIdentityProviderSettings$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerUserSubscriptionsAsyncClient.lambda$updateIdentityProviderSettings$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public final String serviceName() {
        return "license-manager-user-subscriptions";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LicenseManagerUserSubscriptionsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends LicenseManagerUserSubscriptionsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.16").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LicenseManagerUserSubscriptionsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateIdentityProviderSettings$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIdentityProviderSettings$31(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateIdentityProviderSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopProductSubscription$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopProductSubscription$28(List metricPublishers, MetricCollector apiCallMetricCollector, StopProductSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startProductSubscription$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startProductSubscription$25(List metricPublishers, MetricCollector apiCallMetricCollector, StartProductSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerIdentityProvider$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerIdentityProvider$22(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterIdentityProviderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listUserAssociations$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUserAssociations$19(List metricPublishers, MetricCollector apiCallMetricCollector, ListUserAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listProductSubscriptions$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProductSubscriptions$16(List metricPublishers, MetricCollector apiCallMetricCollector, ListProductSubscriptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInstances$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInstances$13(List metricPublishers, MetricCollector apiCallMetricCollector, ListInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIdentityProviders$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityProviders$10(List metricPublishers, MetricCollector apiCallMetricCollector, ListIdentityProvidersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateUser$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateUser$7(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterIdentityProvider$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterIdentityProvider$4(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterIdentityProviderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateUser$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateUser$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

