/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.InternalServerException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ThrottlingException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ValidationException;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable;

/**
 * Service client for accessing AWS License Manager Linux Subscriptions. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * With License Manager, you can discover and track your commercial Linux subscriptions on running Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LicenseManagerLinuxSubscriptionsClient extends AwsClient {
    String SERVICE_NAME = "license-manager-linux-subscriptions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "license-manager-linux-subscriptions";

    /**
     * <p>
     * Lists the Linux subscriptions service settings.
     * </p>
     *
     * @param getServiceSettingsRequest
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Linux subscriptions service settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetServiceSettingsRequest#builder()}
     * </p>
     *
     * @param getServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.GetServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceSettingsResponse getServiceSettings(Consumer<GetServiceSettingsRequest.Builder> getServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return getServiceSettings(GetServiceSettingsRequest.builder().applyMutation(getServiceSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return Result of the ListLinuxSubscriptionInstances operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesResponse listLinuxSubscriptionInstances(
            ListLinuxSubscriptionInstancesRequest listLinuxSubscriptionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinuxSubscriptionInstancesRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListLinuxSubscriptionInstancesRequest.Builder} to
     *        create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if parameters
     *        in request increases.
     * @return Result of the ListLinuxSubscriptionInstances operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesResponse listLinuxSubscriptionInstances(
            Consumer<ListLinuxSubscriptionInstancesRequest.Builder> listLinuxSubscriptionInstancesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionInstances(ListLinuxSubscriptionInstancesRequest.builder()
                .applyMutation(listLinuxSubscriptionInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client
     *             .listLinuxSubscriptionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesIterable listLinuxSubscriptionInstancesPaginator(
            ListLinuxSubscriptionInstancesRequest listLinuxSubscriptionInstancesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return new ListLinuxSubscriptionInstancesIterable(this, listLinuxSubscriptionInstancesRequest);
    }

    /**
     * <p>
     * Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client
     *             .listLinuxSubscriptionInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionInstancesIterable responses = client.listLinuxSubscriptionInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptionInstances(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListLinuxSubscriptionInstancesRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListLinuxSubscriptionInstancesRequest.Builder} to
     *        create a request. NextToken length limit is half of ddb accepted limit. Increase this limit if parameters
     *        in request increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptionInstances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptionInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionInstancesIterable listLinuxSubscriptionInstancesPaginator(
            Consumer<ListLinuxSubscriptionInstancesRequest.Builder> listLinuxSubscriptionInstancesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionInstancesPaginator(ListLinuxSubscriptionInstancesRequest.builder()
                .applyMutation(listLinuxSubscriptionInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return Result of the ListLinuxSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsResponse listLinuxSubscriptions(ListLinuxSubscriptionsRequest listLinuxSubscriptionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLinuxSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLinuxSubscriptionsRequest.Builder} to create a
     *        request. NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in
     *        request increases.
     * @return Result of the ListLinuxSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsResponse listLinuxSubscriptions(
            Consumer<ListLinuxSubscriptionsRequest.Builder> listLinuxSubscriptionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptions(ListLinuxSubscriptionsRequest.builder().applyMutation(listLinuxSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client
     *             .listLinuxSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in request
     *        increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsIterable listLinuxSubscriptionsPaginator(
            ListLinuxSubscriptionsRequest listLinuxSubscriptionsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, LicenseManagerLinuxSubscriptionsException {
        return new ListLinuxSubscriptionsIterable(this, listLinuxSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned
     * results will include data aggregated across your accounts in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client
     *             .listLinuxSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators.ListLinuxSubscriptionsIterable responses = client.listLinuxSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLinuxSubscriptions(software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLinuxSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLinuxSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLinuxSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLinuxSubscriptionsRequest.Builder} to create a
     *        request. NextToken length limit is half of ddb accepted limit. Increase this limit if parameters in
     *        request increases.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.ListLinuxSubscriptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/ListLinuxSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLinuxSubscriptionsIterable listLinuxSubscriptionsPaginator(
            Consumer<ListLinuxSubscriptionsRequest.Builder> listLinuxSubscriptionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return listLinuxSubscriptionsPaginator(ListLinuxSubscriptionsRequest.builder()
                .applyMutation(listLinuxSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Updates the service settings for Linux subscriptions.
     * </p>
     *
     * @param updateServiceSettingsRequest
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UpdateServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the service settings for Linux subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceSettingsRequest#builder()}
     * </p>
     *
     * @param updateServiceSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServiceSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateServiceSettings operation returned by the service.
     * @throws InternalServerException
     *         An exception occurred with the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The provided input is not valid. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LicenseManagerLinuxSubscriptionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LicenseManagerLinuxSubscriptionsClient.UpdateServiceSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/UpdateServiceSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceSettingsResponse updateServiceSettings(
            Consumer<UpdateServiceSettingsRequest.Builder> updateServiceSettingsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            LicenseManagerLinuxSubscriptionsException {
        return updateServiceSettings(UpdateServiceSettingsRequest.builder().applyMutation(updateServiceSettingsRequest).build());
    }

    /**
     * Create a {@link LicenseManagerLinuxSubscriptionsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LicenseManagerLinuxSubscriptionsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LicenseManagerLinuxSubscriptionsClient}.
     */
    static LicenseManagerLinuxSubscriptionsClientBuilder builder() {
        return new DefaultLicenseManagerLinuxSubscriptionsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LicenseManagerLinuxSubscriptionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
