/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseConfigurationAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseConfigurationAssociation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceArn)).setter(LicenseConfigurationAssociation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceTypeAsString)).setter(LicenseConfigurationAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::resourceOwnerId)).setter(LicenseConfigurationAssociation.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").build()}).build();
    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LicenseConfigurationAssociation.getter(LicenseConfigurationAssociation::associationTime)).setter(LicenseConfigurationAssociation.setter(Builder::associationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ID_FIELD, ASSOCIATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceType;
    private final String resourceOwnerId;
    private final Instant associationTime;

    private LicenseConfigurationAssociation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.associationTime = builder.associationTime;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public Instant associationTime() {
        return this.associationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfigurationAssociation)) {
            return false;
        }
        LicenseConfigurationAssociation other = (LicenseConfigurationAssociation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.associationTime(), other.associationTime());
    }

    public String toString() {
        return ToString.builder((String)"LicenseConfigurationAssociation").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("AssociationTime", (Object)this.associationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "AssociationTime": {
                return Optional.ofNullable(clazz.cast(this.associationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfigurationAssociation, T> g) {
        return obj -> g.apply((LicenseConfigurationAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private String resourceOwnerId;
        private Instant associationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfigurationAssociation model) {
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.resourceOwnerId(model.resourceOwnerId);
            this.associationTime(model.associationTime);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final Instant getAssociationTime() {
            return this.associationTime;
        }

        @Override
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        public LicenseConfigurationAssociation build() {
            return new LicenseConfigurationAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseConfigurationAssociation> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceOwnerId(String var1);

        public Builder associationTime(Instant var1);
    }
}

