/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInventory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceInventory> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::resourceId)).setter(ResourceInventory.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::resourceTypeAsString)).setter(ResourceInventory.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::resourceArn)).setter(ResourceInventory.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::platform)).setter(ResourceInventory.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::platformVersion)).setter(ResourceInventory.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> RESOURCE_OWNING_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceInventory.getter(ResourceInventory::resourceOwningAccountId)).setter(ResourceInventory.setter(Builder::resourceOwningAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwningAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ARN_FIELD, PLATFORM_FIELD, PLATFORM_VERSION_FIELD, RESOURCE_OWNING_ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceType;
    private final String resourceArn;
    private final String platform;
    private final String platformVersion;
    private final String resourceOwningAccountId;

    private ResourceInventory(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceArn = builder.resourceArn;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.resourceOwningAccountId = builder.resourceOwningAccountId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public String platform() {
        return this.platform;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String resourceOwningAccountId() {
        return this.resourceOwningAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwningAccountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInventory)) {
            return false;
        }
        ResourceInventory other = (ResourceInventory)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.resourceOwningAccountId(), other.resourceOwningAccountId());
    }

    public String toString() {
        return ToString.builder((String)"ResourceInventory").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("Platform", (Object)this.platform()).add("PlatformVersion", (Object)this.platformVersion()).add("ResourceOwningAccountId", (Object)this.resourceOwningAccountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ResourceOwningAccountId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwningAccountId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceInventory, T> g) {
        return obj -> g.apply((ResourceInventory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String resourceArn;
        private String platform;
        private String platformVersion;
        private String resourceOwningAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInventory model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceArn(model.resourceArn);
            this.platform(model.platform);
            this.platformVersion(model.platformVersion);
            this.resourceOwningAccountId(model.resourceOwningAccountId);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getResourceOwningAccountId() {
            return this.resourceOwningAccountId;
        }

        @Override
        public final Builder resourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
            return this;
        }

        public final void setResourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
        }

        public ResourceInventory build() {
            return new ResourceInventory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceInventory> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceArn(String var1);

        public Builder platform(String var1);

        public Builder platformVersion(String var1);

        public Builder resourceOwningAccountId(String var1);
    }
}

