/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2AsyncClient;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2BaseClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2AsyncClient;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2AsyncClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2ServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntimev2.endpoints.LexRuntimeV2EndpointProvider;

@SdkInternalApi
final class DefaultLexRuntimeV2AsyncClientBuilder
extends DefaultLexRuntimeV2BaseClientBuilder<LexRuntimeV2AsyncClientBuilder, LexRuntimeV2AsyncClient>
implements LexRuntimeV2AsyncClientBuilder {
    DefaultLexRuntimeV2AsyncClientBuilder() {
    }

    @Override
    public DefaultLexRuntimeV2AsyncClientBuilder endpointProvider(LexRuntimeV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LexRuntimeV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLexRuntimeV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        LexRuntimeV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLexRuntimeV2AsyncClient client = new DefaultLexRuntimeV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LexRuntimeV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LexRuntimeV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

