/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MessageContentType {
    CUSTOM_PAYLOAD("CustomPayload"),
    IMAGE_RESPONSE_CARD("ImageResponseCard"),
    PLAIN_TEXT("PlainText"),
    SSML("SSML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MessageContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MessageContentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageContentType> knownValues() {
        return Stream.of(MessageContentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

