/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event sent from Amazon Lex to your client application containing audio to play to the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AudioResponseEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioResponseEvent.Builder, AudioResponseEvent>, StartConversationResponseEventStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("audioChunk").getter(getter(AudioResponseEvent::audioChunk)).setter(setter(Builder::audioChunk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChunk").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(AudioResponseEvent::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(AudioResponseEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD,
            CONTENT_TYPE_FIELD, EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes audioChunk;

    private final String contentType;

    private final String eventId;

    protected AudioResponseEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
        this.contentType = builder.contentType;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * A chunk of the audio to play.
     * </p>
     * 
     * @return A chunk of the audio to play.
     */
    public final SdkBytes audioChunk() {
        return audioChunk;
    }

    /**
     * <p>
     * The encoding of the audio chunk. This is the same as the encoding configure in the <code>contentType</code> field
     * of the <code>ConfigurationEvent</code>.
     * </p>
     * 
     * @return The encoding of the audio chunk. This is the same as the encoding configure in the
     *         <code>contentType</code> field of the <code>ConfigurationEvent</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A unique identifier of the event sent by Amazon Lex. The identifier is in the form <code>RESPONSE-N</code>, where
     * N is a number starting with one and incremented for each event sent by Amazon Lex in the current session.
     * </p>
     * 
     * @return A unique identifier of the event sent by Amazon Lex. The identifier is in the form
     *         <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
     *         Amazon Lex in the current session.
     */
    public final String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioChunk());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioResponseEvent)) {
            return false;
        }
        AudioResponseEvent other = (AudioResponseEvent) obj;
        return Objects.equals(audioChunk(), other.audioChunk()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(eventId(), other.eventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioResponseEvent").add("AudioChunk", audioChunk()).add("ContentType", contentType())
                .add("EventId", eventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioChunk":
            return Optional.ofNullable(clazz.cast(audioChunk()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final AudioResponseEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioResponseEvent, T> g) {
        return obj -> g.apply((AudioResponseEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link AudioResponseEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(StartConversationResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioResponseEvent> {
        /**
         * <p>
         * A chunk of the audio to play.
         * </p>
         * 
         * @param audioChunk
         *        A chunk of the audio to play.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChunk(SdkBytes audioChunk);

        /**
         * <p>
         * The encoding of the audio chunk. This is the same as the encoding configure in the <code>contentType</code>
         * field of the <code>ConfigurationEvent</code>.
         * </p>
         * 
         * @param contentType
         *        The encoding of the audio chunk. This is the same as the encoding configure in the
         *        <code>contentType</code> field of the <code>ConfigurationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A unique identifier of the event sent by Amazon Lex. The identifier is in the form <code>RESPONSE-N</code>,
         * where N is a number starting with one and incremented for each event sent by Amazon Lex in the current
         * session.
         * </p>
         * 
         * @param eventId
         *        A unique identifier of the event sent by Amazon Lex. The identifier is in the form
         *        <code>RESPONSE-N</code>, where N is a number starting with one and incremented for each event sent by
         *        Amazon Lex in the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    protected static class BuilderImpl implements Builder {
        private SdkBytes audioChunk;

        private String contentType;

        private String eventId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AudioResponseEvent model) {
            audioChunk(model.audioChunk);
            contentType(model.contentType);
            eventId(model.eventId);
        }

        public final ByteBuffer getAudioChunk() {
            return audioChunk == null ? null : audioChunk.asByteBuffer();
        }

        @Override
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = StandardMemberCopier.copy(audioChunk);
            return this;
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer(audioChunk));
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public AudioResponseEvent build() {
            return new AudioResponseEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
