/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeAsyncClient;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClient;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntime.endpoints.LexRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultLexRuntimeAsyncClientBuilder
extends DefaultLexRuntimeBaseClientBuilder<LexRuntimeAsyncClientBuilder, LexRuntimeAsyncClient>
implements LexRuntimeAsyncClientBuilder {
    DefaultLexRuntimeAsyncClientBuilder() {
    }

    @Override
    public DefaultLexRuntimeAsyncClientBuilder endpointProvider(LexRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LexRuntimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLexRuntimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        LexRuntimeServiceClientConfiguration serviceClientConfiguration = LexRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultLexRuntimeAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

