/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.lexruntime.DefaultLexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.lexruntime.LexRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.GetSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.GetSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.services.lexruntime.model.PostContentResponse;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.services.lexruntime.model.PostTextResponse;
import software.amazon.awssdk.services.lexruntime.model.PutSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.PutSessionResponse;

@SdkPublicApi
@ThreadSafe
public interface LexRuntimeAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "lex";
    public static final String SERVICE_METADATA_ID = "runtime.lex";

    default public CompletableFuture<DeleteSessionResponse> deleteSession(DeleteSessionRequest deleteSessionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteSessionResponse> deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) {
        return this.deleteSession((DeleteSessionRequest)((Object)((DeleteSessionRequest.Builder)DeleteSessionRequest.builder().applyMutation(deleteSessionRequest)).build()));
    }

    default public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return this.getSession((GetSessionRequest)((Object)((GetSessionRequest.Builder)GetSessionRequest.builder().applyMutation(getSessionRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> postContent(PostContentRequest postContentRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<PostContentResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> postContent(Consumer<PostContentRequest.Builder> postContentRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<PostContentResponse, ReturnT> asyncResponseTransformer) {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), requestBody, asyncResponseTransformer);
    }

    default public CompletableFuture<PostContentResponse> postContent(PostContentRequest postContentRequest, Path sourcePath, Path destinationPath) {
        return this.postContent(postContentRequest, AsyncRequestBody.fromFile((Path)sourcePath), AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<PostContentResponse> postContent(Consumer<PostContentRequest.Builder> postContentRequest, Path sourcePath, Path destinationPath) {
        return this.postContent((PostContentRequest)((Object)((PostContentRequest.Builder)PostContentRequest.builder().applyMutation(postContentRequest)).build()), sourcePath, destinationPath);
    }

    default public CompletableFuture<PostTextResponse> postText(PostTextRequest postTextRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PostTextResponse> postText(Consumer<PostTextRequest.Builder> postTextRequest) {
        return this.postText((PostTextRequest)((Object)((PostTextRequest.Builder)PostTextRequest.builder().applyMutation(postTextRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> putSession(PutSessionRequest putSessionRequest, AsyncResponseTransformer<PutSessionResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, AsyncResponseTransformer<PutSessionResponse, ReturnT> asyncResponseTransformer) {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<PutSessionResponse> putSession(PutSessionRequest putSessionRequest, Path destinationPath) {
        return this.putSession(putSessionRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<PutSessionResponse> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, Path destinationPath) {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), destinationPath);
    }

    public LexRuntimeServiceClientConfiguration serviceClientConfiguration();

    public static LexRuntimeAsyncClient create() {
        return (LexRuntimeAsyncClient)LexRuntimeAsyncClient.builder().build();
    }

    public static LexRuntimeAsyncClientBuilder builder() {
        return new DefaultLexRuntimeAsyncClientBuilder();
    }
}

