/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.DialogState;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.services.lexruntime.model.MessageFormatType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSessionResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, PutSessionResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(PutSessionResponse.getter(PutSessionResponse::contentType)).setter(PutSessionResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(PutSessionResponse.getter(PutSessionResponse::intentName)).setter(PutSessionResponse.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-intent-name").build()}).build();
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slots").getter(PutSessionResponse.getter(PutSessionResponse::slots)).setter(PutSessionResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slots").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionAttributes").getter(PutSessionResponse.getter(PutSessionResponse::sessionAttributes)).setter(PutSessionResponse.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-attributes").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(PutSessionResponse.getter(PutSessionResponse::message)).setter(PutSessionResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message").build()}).build();
    private static final SdkField<String> ENCODED_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encodedMessage").getter(PutSessionResponse.getter(PutSessionResponse::encodedMessage)).setter(PutSessionResponse.setter(Builder::encodedMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-encoded-message").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageFormat").getter(PutSessionResponse.getter(PutSessionResponse::messageFormatAsString)).setter(PutSessionResponse.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-message-format").build()}).build();
    private static final SdkField<String> DIALOG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dialogState").getter(PutSessionResponse.getter(PutSessionResponse::dialogStateAsString)).setter(PutSessionResponse.setter(Builder::dialogState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-dialog-state").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotToElicit").getter(PutSessionResponse.getter(PutSessionResponse::slotToElicit)).setter(PutSessionResponse.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-slot-to-elicit").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(PutSessionResponse.getter(PutSessionResponse::sessionId)).setter(PutSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-session-id").build()}).build();
    private static final SdkField<String> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeContexts").getter(PutSessionResponse.getter(PutSessionResponse::activeContexts)).setter(PutSessionResponse.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-lex-active-contexts").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, INTENT_NAME_FIELD, SLOTS_FIELD, SESSION_ATTRIBUTES_FIELD, MESSAGE_FIELD, ENCODED_MESSAGE_FIELD, MESSAGE_FORMAT_FIELD, DIALOG_STATE_FIELD, SLOT_TO_ELICIT_FIELD, SESSION_ID_FIELD, ACTIVE_CONTEXTS_FIELD));
    private final String contentType;
    private final String intentName;
    private final String slots;
    private final String sessionAttributes;
    private final String message;
    private final String encodedMessage;
    private final String messageFormat;
    private final String dialogState;
    private final String slotToElicit;
    private final String sessionId;
    private final String activeContexts;

    private PutSessionResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.intentName = builder.intentName;
        this.slots = builder.slots;
        this.sessionAttributes = builder.sessionAttributes;
        this.message = builder.message;
        this.encodedMessage = builder.encodedMessage;
        this.messageFormat = builder.messageFormat;
        this.dialogState = builder.dialogState;
        this.slotToElicit = builder.slotToElicit;
        this.sessionId = builder.sessionId;
        this.activeContexts = builder.activeContexts;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String slots() {
        return this.slots;
    }

    public final String sessionAttributes() {
        return this.sessionAttributes;
    }

    @Deprecated
    public final String message() {
        return this.message;
    }

    public final String encodedMessage() {
        return this.encodedMessage;
    }

    public final MessageFormatType messageFormat() {
        return MessageFormatType.fromValue(this.messageFormat);
    }

    public final String messageFormatAsString() {
        return this.messageFormat;
    }

    public final DialogState dialogState() {
        return DialogState.fromValue(this.dialogState);
    }

    public final String dialogStateAsString() {
        return this.dialogState;
    }

    public final String slotToElicit() {
        return this.slotToElicit;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String activeContexts() {
        return this.activeContexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeContexts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSessionResponse)) {
            return false;
        }
        PutSessionResponse other = (PutSessionResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sessionAttributes(), other.sessionAttributes()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.encodedMessage(), other.encodedMessage()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.dialogStateAsString(), other.dialogStateAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.activeContexts(), other.activeContexts());
    }

    public final String toString() {
        return ToString.builder((String)"PutSessionResponse").add("ContentType", (Object)this.contentType()).add("IntentName", (Object)this.intentName()).add("Slots", (Object)this.slots()).add("SessionAttributes", (Object)this.sessionAttributes()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("EncodedMessage", (Object)(this.encodedMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("MessageFormat", (Object)this.messageFormatAsString()).add("DialogState", (Object)this.dialogStateAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("SessionId", (Object)this.sessionId()).add("ActiveContexts", (Object)(this.activeContexts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "encodedMessage": {
                return Optional.ofNullable(clazz.cast(this.encodedMessage()));
            }
            case "messageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "dialogState": {
                return Optional.ofNullable(clazz.cast(this.dialogStateAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSessionResponse, T> g) {
        return obj -> g.apply((PutSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private String intentName;
        private String slots;
        private String sessionAttributes;
        private String message;
        private String encodedMessage;
        private String messageFormat;
        private String dialogState;
        private String slotToElicit;
        private String sessionId;
        private String activeContexts;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSessionResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.intentName(model.intentName);
            this.slots(model.slots);
            this.sessionAttributes(model.sessionAttributes);
            this.message(model.message);
            this.encodedMessage(model.encodedMessage);
            this.messageFormat(model.messageFormat);
            this.dialogState(model.dialogState);
            this.slotToElicit(model.slotToElicit);
            this.sessionId(model.sessionId);
            this.activeContexts(model.activeContexts);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getSlots() {
            return this.slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        public final String getSessionAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public final void setSessionAttributes(String sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        @Deprecated
        public final String getMessage() {
            return this.message;
        }

        @Override
        @Deprecated
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Deprecated
        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getEncodedMessage() {
            return this.encodedMessage;
        }

        @Override
        public final Builder encodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
            return this;
        }

        public final void setEncodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatType messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getDialogState() {
            return this.dialogState;
        }

        @Override
        public final Builder dialogState(String dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @Override
        public final Builder dialogState(DialogState dialogState) {
            this.dialogState(dialogState == null ? null : dialogState.toString());
            return this;
        }

        public final void setDialogState(String dialogState) {
            this.dialogState = dialogState;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getActiveContexts() {
            return this.activeContexts;
        }

        @Override
        public final Builder activeContexts(String activeContexts) {
            this.activeContexts = activeContexts;
            return this;
        }

        public final void setActiveContexts(String activeContexts) {
            this.activeContexts = activeContexts;
        }

        @Override
        public PutSessionResponse build() {
            return new PutSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSessionResponse> {
        public Builder contentType(String var1);

        public Builder intentName(String var1);

        public Builder slots(String var1);

        public Builder sessionAttributes(String var1);

        @Deprecated
        public Builder message(String var1);

        public Builder encodedMessage(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatType var1);

        public Builder dialogState(String var1);

        public Builder dialogState(DialogState var1);

        public Builder slotToElicit(String var1);

        public Builder sessionId(String var1);

        public Builder activeContexts(String var1);
    }
}

