/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an option rendered to the user when a prompt is shown. It could be an image, a button, a link, or text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenericAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<GenericAttachment.Builder, GenericAttachment> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GenericAttachment::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> SUB_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subTitle").getter(getter(GenericAttachment::subTitle)).setter(setter(Builder::subTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subTitle").build()).build();

    private static final SdkField<String> ATTACHMENT_LINK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentLinkUrl").getter(getter(GenericAttachment::attachmentLinkUrl))
            .setter(setter(Builder::attachmentLinkUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentLinkUrl").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageUrl").getter(getter(GenericAttachment::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUrl").build()).build();

    private static final SdkField<List<Button>> BUTTONS_FIELD = SdkField
            .<List<Button>> builder(MarshallingType.LIST)
            .memberName("buttons")
            .getter(getter(GenericAttachment::buttons))
            .setter(setter(Builder::buttons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buttons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Button> builder(MarshallingType.SDK_POJO)
                                            .constructor(Button::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SUB_TITLE_FIELD,
            ATTACHMENT_LINK_URL_FIELD, IMAGE_URL_FIELD, BUTTONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String subTitle;

    private final String attachmentLinkUrl;

    private final String imageUrl;

    private final List<Button> buttons;

    private GenericAttachment(BuilderImpl builder) {
        this.title = builder.title;
        this.subTitle = builder.subTitle;
        this.attachmentLinkUrl = builder.attachmentLinkUrl;
        this.imageUrl = builder.imageUrl;
        this.buttons = builder.buttons;
    }

    /**
     * <p>
     * The title of the option.
     * </p>
     * 
     * @return The title of the option.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The subtitle shown below the title.
     * </p>
     * 
     * @return The subtitle shown below the title.
     */
    public final String subTitle() {
        return subTitle;
    }

    /**
     * <p>
     * The URL of an attachment to the response card.
     * </p>
     * 
     * @return The URL of an attachment to the response card.
     */
    public final String attachmentLinkUrl() {
        return attachmentLinkUrl;
    }

    /**
     * <p>
     * The URL of an image that is displayed to the user.
     * </p>
     * 
     * @return The URL of an image that is displayed to the user.
     */
    public final String imageUrl() {
        return imageUrl;
    }

    /**
     * Returns true if the Buttons property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasButtons() {
        return buttons != null && !(buttons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of options to show to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasButtons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of options to show to the user.
     */
    public final List<Button> buttons() {
        return buttons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subTitle());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentLinkUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasButtons() ? buttons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericAttachment)) {
            return false;
        }
        GenericAttachment other = (GenericAttachment) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(subTitle(), other.subTitle())
                && Objects.equals(attachmentLinkUrl(), other.attachmentLinkUrl()) && Objects.equals(imageUrl(), other.imageUrl())
                && hasButtons() == other.hasButtons() && Objects.equals(buttons(), other.buttons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenericAttachment").add("Title", title()).add("SubTitle", subTitle())
                .add("AttachmentLinkUrl", attachmentLinkUrl()).add("ImageUrl", imageUrl())
                .add("Buttons", hasButtons() ? buttons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "subTitle":
            return Optional.ofNullable(clazz.cast(subTitle()));
        case "attachmentLinkUrl":
            return Optional.ofNullable(clazz.cast(attachmentLinkUrl()));
        case "imageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "buttons":
            return Optional.ofNullable(clazz.cast(buttons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenericAttachment, T> g) {
        return obj -> g.apply((GenericAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenericAttachment> {
        /**
         * <p>
         * The title of the option.
         * </p>
         * 
         * @param title
         *        The title of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The subtitle shown below the title.
         * </p>
         * 
         * @param subTitle
         *        The subtitle shown below the title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subTitle(String subTitle);

        /**
         * <p>
         * The URL of an attachment to the response card.
         * </p>
         * 
         * @param attachmentLinkUrl
         *        The URL of an attachment to the response card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentLinkUrl(String attachmentLinkUrl);

        /**
         * <p>
         * The URL of an image that is displayed to the user.
         * </p>
         * 
         * @param imageUrl
         *        The URL of an image that is displayed to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The list of options to show to the user.
         * </p>
         * 
         * @param buttons
         *        The list of options to show to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buttons(Collection<Button> buttons);

        /**
         * <p>
         * The list of options to show to the user.
         * </p>
         * 
         * @param buttons
         *        The list of options to show to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buttons(Button... buttons);

        /**
         * <p>
         * The list of options to show to the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Button>.Builder} avoiding the need to
         * create one manually via {@link List<Button>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Button>.Builder#build()} is called immediately and its
         * result is passed to {@link #buttons(List<Button>)}.
         * 
         * @param buttons
         *        a consumer that will call methods on {@link List<Button>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buttons(List<Button>)
         */
        Builder buttons(Consumer<Button.Builder>... buttons);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String subTitle;

        private String attachmentLinkUrl;

        private String imageUrl;

        private List<Button> buttons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenericAttachment model) {
            title(model.title);
            subTitle(model.subTitle);
            attachmentLinkUrl(model.attachmentLinkUrl);
            imageUrl(model.imageUrl);
            buttons(model.buttons);
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getSubTitle() {
            return subTitle;
        }

        @Override
        public final Builder subTitle(String subTitle) {
            this.subTitle = subTitle;
            return this;
        }

        public final void setSubTitle(String subTitle) {
            this.subTitle = subTitle;
        }

        public final String getAttachmentLinkUrl() {
            return attachmentLinkUrl;
        }

        @Override
        public final Builder attachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
            return this;
        }

        public final void setAttachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final Collection<Button.Builder> getButtons() {
            if (buttons instanceof SdkAutoConstructList) {
                return null;
            }
            return buttons != null ? buttons.stream().map(Button::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buttons(Collection<Button> buttons) {
            this.buttons = _listOfButtonsCopier.copy(buttons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Button... buttons) {
            buttons(Arrays.asList(buttons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Consumer<Button.Builder>... buttons) {
            buttons(Stream.of(buttons).map(c -> Button.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setButtons(Collection<Button.BuilderImpl> buttons) {
            this.buttons = _listOfButtonsCopier.copyFromBuilder(buttons);
        }

        @Override
        public GenericAttachment build() {
            return new GenericAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
