/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PostContentRequestModelMarshaller {
    private static final MarshallingInfo<String> BOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("botName").isBinary(false).build();
    private static final MarshallingInfo<String> BOTALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("botAlias").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("userId").isBinary(false).build();
    private static final MarshallingInfo<String> SESSIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-lex-session-attributes").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-lex-request-attributes").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Type").isBinary(false).build();
    private static final MarshallingInfo<String> ACCEPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Accept").isBinary(false).build();
    private static final PostContentRequestModelMarshaller INSTANCE = new PostContentRequestModelMarshaller();

    private PostContentRequestModelMarshaller() {
    }

    public static PostContentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PostContentRequest postContentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)postContentRequest), (String)"postContentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)postContentRequest.botName(), BOTNAME_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.botAlias(), BOTALIAS_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.sessionAttributes(), SESSIONATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.requestAttributes(), REQUESTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)postContentRequest.accept(), ACCEPT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

