/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexruntime.model.Button;
import software.amazon.awssdk.services.lexruntime.model._listOfButtonsCopier;
import software.amazon.awssdk.services.lexruntime.transform.GenericAttachmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenericAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, GenericAttachment> {
    private final String title;
    private final String subTitle;
    private final String attachmentLinkUrl;
    private final String imageUrl;
    private final List<Button> buttons;

    private GenericAttachment(BuilderImpl builder) {
        this.title = builder.title;
        this.subTitle = builder.subTitle;
        this.attachmentLinkUrl = builder.attachmentLinkUrl;
        this.imageUrl = builder.imageUrl;
        this.buttons = builder.buttons;
    }

    public String title() {
        return this.title;
    }

    public String subTitle() {
        return this.subTitle;
    }

    public String attachmentLinkUrl() {
        return this.attachmentLinkUrl;
    }

    public String imageUrl() {
        return this.imageUrl;
    }

    public List<Button> buttons() {
        return this.buttons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentLinkUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.buttons());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericAttachment)) {
            return false;
        }
        GenericAttachment other = (GenericAttachment)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.subTitle(), other.subTitle()) && Objects.equals(this.attachmentLinkUrl(), other.attachmentLinkUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.buttons(), other.buttons());
    }

    public String toString() {
        return ToString.builder((String)"GenericAttachment").add("Title", (Object)this.title()).add("SubTitle", (Object)this.subTitle()).add("AttachmentLinkUrl", (Object)this.attachmentLinkUrl()).add("ImageUrl", (Object)this.imageUrl()).add("Buttons", this.buttons()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "subTitle": {
                return Optional.ofNullable(clazz.cast(this.subTitle()));
            }
            case "attachmentLinkUrl": {
                return Optional.ofNullable(clazz.cast(this.attachmentLinkUrl()));
            }
            case "imageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "buttons": {
                return Optional.ofNullable(clazz.cast(this.buttons()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenericAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String subTitle;
        private String attachmentLinkUrl;
        private String imageUrl;
        private List<Button> buttons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenericAttachment model) {
            this.title(model.title);
            this.subTitle(model.subTitle);
            this.attachmentLinkUrl(model.attachmentLinkUrl);
            this.imageUrl(model.imageUrl);
            this.buttons(model.buttons);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getSubTitle() {
            return this.subTitle;
        }

        @Override
        public final Builder subTitle(String subTitle) {
            this.subTitle = subTitle;
            return this;
        }

        public final void setSubTitle(String subTitle) {
            this.subTitle = subTitle;
        }

        public final String getAttachmentLinkUrl() {
            return this.attachmentLinkUrl;
        }

        @Override
        public final Builder attachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
            return this;
        }

        public final void setAttachmentLinkUrl(String attachmentLinkUrl) {
            this.attachmentLinkUrl = attachmentLinkUrl;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final Collection<Button.Builder> getButtons() {
            return this.buttons != null ? (Collection)this.buttons.stream().map(Button::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buttons(Collection<Button> buttons) {
            this.buttons = _listOfButtonsCopier.copy(buttons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Button ... buttons) {
            this.buttons(Arrays.asList(buttons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Consumer<Button.Builder> ... buttons) {
            this.buttons(Stream.of(buttons).map(c -> (Button)((Button.Builder)Button.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setButtons(Collection<Button.BuilderImpl> buttons) {
            this.buttons = _listOfButtonsCopier.copyFromBuilder(buttons);
        }

        public GenericAttachment build() {
            return new GenericAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenericAttachment> {
        public Builder title(String var1);

        public Builder subTitle(String var1);

        public Builder attachmentLinkUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder buttons(Collection<Button> var1);

        public Builder buttons(Button ... var1);

        public Builder buttons(Consumer<Button.Builder> ... var1);
    }
}

