/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBotRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateBotRequest.Builder, UpdateBotRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateBotRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(UpdateBotRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateBotRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(UpdateBotRequest::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(UpdateBotRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botType").getter(getter(UpdateBotRequest::botTypeAsString)).setter(setter(Builder::botType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botType").build()).build();

    private static final SdkField<List<BotMember>> BOT_MEMBERS_FIELD = SdkField
            .<List<BotMember>> builder(MarshallingType.LIST)
            .memberName("botMembers")
            .getter(getter(UpdateBotRequest::botMembers))
            .setter(setter(Builder::botMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorLogSettings> ERROR_LOG_SETTINGS_FIELD = SdkField
            .<ErrorLogSettings> builder(MarshallingType.SDK_POJO).memberName("errorLogSettings")
            .getter(getter(UpdateBotRequest::errorLogSettings)).setter(setter(Builder::errorLogSettings))
            .constructor(ErrorLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorLogSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_TYPE_FIELD,
            BOT_MEMBERS_FIELD, ERROR_LOG_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botName;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final String botType;

    private final List<BotMember> botMembers;

    private final ErrorLogSettings errorLogSettings;

    private UpdateBotRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botType = builder.botType;
        this.botMembers = builder.botMembers;
        this.errorLogSettings = builder.errorLogSettings;
    }

    /**
     * <p>
     * The unique identifier of the bot to update. This identifier is returned by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation.
     * </p>
     * 
     * @return The unique identifier of the bot to update. This identifier is returned by the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The new name of the bot. The name must be unique in the account that creates the bot.
     * </p>
     * 
     * @return The new name of the bot. The name must be unique in the account that creates the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     * </p>
     * 
     * @return Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Lex deletes any data provided before the timeout.
     * </p>
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     * </p>
     * 
     * @return The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
     *         bot.</p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *         </p>
     *         <p>
     *         You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The type of the bot to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot to be updated.
     * @see BotType
     */
    public final BotType botType() {
        return BotType.fromValue(botType);
    }

    /**
     * <p>
     * The type of the bot to be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot to be updated.
     * @see BotType
     */
    public final String botTypeAsString() {
        return botType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotMembers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBotMembers() {
        return botMembers != null && !(botMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of bot members in the network associated with the update action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotMembers} method.
     * </p>
     * 
     * @return The list of bot members in the network associated with the update action.
     */
    public final List<BotMember> botMembers() {
        return botMembers;
    }

    /**
     * <p>
     * Allows you to modify how Amazon Lex logs errors during bot interactions, including destinations for error logs
     * and the types of errors to be captured.
     * </p>
     * 
     * @return Allows you to modify how Amazon Lex logs errors during bot interactions, including destinations for error
     *         logs and the types of errors to be captured.
     */
    public final ErrorLogSettings errorLogSettings() {
        return errorLogSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotMembers() ? botMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorLogSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotRequest)) {
            return false;
        }
        UpdateBotRequest other = (UpdateBotRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(botTypeAsString(), other.botTypeAsString()) && hasBotMembers() == other.hasBotMembers()
                && Objects.equals(botMembers(), other.botMembers())
                && Objects.equals(errorLogSettings(), other.errorLogSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBotRequest").add("BotId", botId()).add("BotName", botName())
                .add("Description", description()).add("RoleArn", roleArn()).add("DataPrivacy", dataPrivacy())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).add("BotType", botTypeAsString())
                .add("BotMembers", hasBotMembers() ? botMembers() : null).add("ErrorLogSettings", errorLogSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botType":
            return Optional.ofNullable(clazz.cast(botTypeAsString()));
        case "botMembers":
            return Optional.ofNullable(clazz.cast(botMembers()));
        case "errorLogSettings":
            return Optional.ofNullable(clazz.cast(errorLogSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("dataPrivacy", DATA_PRIVACY_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("botType", BOT_TYPE_FIELD);
        map.put("botMembers", BOT_MEMBERS_FIELD);
        map.put("errorLogSettings", ERROR_LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotRequest, T> g) {
        return obj -> g.apply((UpdateBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBotRequest> {
        /**
         * <p>
         * The unique identifier of the bot to update. This identifier is returned by the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot to update. This identifier is returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The new name of the bot. The name must be unique in the account that creates the bot.
         * </p>
         * 
         * @param botName
         *        The new name of the bot. The name must be unique in the account that creates the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * 
         * @param dataPrivacy
         *        Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to
         * create one manually via {@link DataPrivacy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * </p>
         * <p>
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
         *        bot.</p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *        </p>
         *        <p>
         *        You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The type of the bot to be updated.
         * </p>
         * 
         * @param botType
         *        The type of the bot to be updated.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(String botType);

        /**
         * <p>
         * The type of the bot to be updated.
         * </p>
         * 
         * @param botType
         *        The type of the bot to be updated.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(BotType botType);

        /**
         * <p>
         * The list of bot members in the network associated with the update action.
         * </p>
         * 
         * @param botMembers
         *        The list of bot members in the network associated with the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(Collection<BotMember> botMembers);

        /**
         * <p>
         * The list of bot members in the network associated with the update action.
         * </p>
         * 
         * @param botMembers
         *        The list of bot members in the network associated with the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(BotMember... botMembers);

        /**
         * <p>
         * The list of bot members in the network associated with the update action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder#build()} is called immediately and
         * its result is passed to {@link #botMembers(List<BotMember>)}.
         * 
         * @param botMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botMembers(java.util.Collection<BotMember>)
         */
        Builder botMembers(Consumer<BotMember.Builder>... botMembers);

        /**
         * <p>
         * Allows you to modify how Amazon Lex logs errors during bot interactions, including destinations for error
         * logs and the types of errors to be captured.
         * </p>
         * 
         * @param errorLogSettings
         *        Allows you to modify how Amazon Lex logs errors during bot interactions, including destinations for
         *        error logs and the types of errors to be captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorLogSettings(ErrorLogSettings errorLogSettings);

        /**
         * <p>
         * Allows you to modify how Amazon Lex logs errors during bot interactions, including destinations for error
         * logs and the types of errors to be captured.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorLogSettings.Builder} avoiding the
         * need to create one manually via {@link ErrorLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #errorLogSettings(ErrorLogSettings)}.
         * 
         * @param errorLogSettings
         *        a consumer that will call methods on {@link ErrorLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorLogSettings(ErrorLogSettings)
         */
        default Builder errorLogSettings(Consumer<ErrorLogSettings.Builder> errorLogSettings) {
            return errorLogSettings(ErrorLogSettings.builder().applyMutation(errorLogSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private String botType;

        private List<BotMember> botMembers = DefaultSdkAutoConstructList.getInstance();

        private ErrorLogSettings errorLogSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotRequest model) {
            super(model);
            botId(model.botId);
            botName(model.botName);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botType(model.botType);
            botMembers(model.botMembers);
            errorLogSettings(model.errorLogSettings);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getBotType() {
            return botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final List<BotMember.Builder> getBotMembers() {
            List<BotMember.Builder> result = BotMembersCopier.copyToBuilder(this.botMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotMembers(Collection<BotMember.BuilderImpl> botMembers) {
            this.botMembers = BotMembersCopier.copyFromBuilder(botMembers);
        }

        @Override
        public final Builder botMembers(Collection<BotMember> botMembers) {
            this.botMembers = BotMembersCopier.copy(botMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(BotMember... botMembers) {
            botMembers(Arrays.asList(botMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(Consumer<BotMember.Builder>... botMembers) {
            botMembers(Stream.of(botMembers).map(c -> BotMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorLogSettings.Builder getErrorLogSettings() {
            return errorLogSettings != null ? errorLogSettings.toBuilder() : null;
        }

        public final void setErrorLogSettings(ErrorLogSettings.BuilderImpl errorLogSettings) {
            this.errorLogSettings = errorLogSettings != null ? errorLogSettings.build() : null;
        }

        @Override
        public final Builder errorLogSettings(ErrorLogSettings errorLogSettings) {
            this.errorLogSettings = errorLogSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBotRequest build() {
            return new UpdateBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
