/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the setting of the location where the transcript is stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptSourceSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptSourceSetting.Builder, TranscriptSourceSetting> {
    private static final SdkField<S3BucketTranscriptSource> S3_BUCKET_TRANSCRIPT_SOURCE_FIELD = SdkField
            .<S3BucketTranscriptSource> builder(MarshallingType.SDK_POJO).memberName("s3BucketTranscriptSource")
            .getter(getter(TranscriptSourceSetting::s3BucketTranscriptSource)).setter(setter(Builder::s3BucketTranscriptSource))
            .constructor(S3BucketTranscriptSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketTranscriptSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_BUCKET_TRANSCRIPT_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3BucketTranscriptSource s3BucketTranscriptSource;

    private TranscriptSourceSetting(BuilderImpl builder) {
        this.s3BucketTranscriptSource = builder.s3BucketTranscriptSource;
    }

    /**
     * <p>
     * Indicates the setting of the Amazon S3 bucket where the transcript is stored.
     * </p>
     * 
     * @return Indicates the setting of the Amazon S3 bucket where the transcript is stored.
     */
    public final S3BucketTranscriptSource s3BucketTranscriptSource() {
        return s3BucketTranscriptSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketTranscriptSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptSourceSetting)) {
            return false;
        }
        TranscriptSourceSetting other = (TranscriptSourceSetting) obj;
        return Objects.equals(s3BucketTranscriptSource(), other.s3BucketTranscriptSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptSourceSetting").add("S3BucketTranscriptSource", s3BucketTranscriptSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3BucketTranscriptSource":
            return Optional.ofNullable(clazz.cast(s3BucketTranscriptSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3BucketTranscriptSource", S3_BUCKET_TRANSCRIPT_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranscriptSourceSetting, T> g) {
        return obj -> g.apply((TranscriptSourceSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptSourceSetting> {
        /**
         * <p>
         * Indicates the setting of the Amazon S3 bucket where the transcript is stored.
         * </p>
         * 
         * @param s3BucketTranscriptSource
         *        Indicates the setting of the Amazon S3 bucket where the transcript is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketTranscriptSource(S3BucketTranscriptSource s3BucketTranscriptSource);

        /**
         * <p>
         * Indicates the setting of the Amazon S3 bucket where the transcript is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketTranscriptSource.Builder}
         * avoiding the need to create one manually via {@link S3BucketTranscriptSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketTranscriptSource.Builder#build()} is called immediately
         * and its result is passed to {@link #s3BucketTranscriptSource(S3BucketTranscriptSource)}.
         * 
         * @param s3BucketTranscriptSource
         *        a consumer that will call methods on {@link S3BucketTranscriptSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketTranscriptSource(S3BucketTranscriptSource)
         */
        default Builder s3BucketTranscriptSource(Consumer<S3BucketTranscriptSource.Builder> s3BucketTranscriptSource) {
            return s3BucketTranscriptSource(S3BucketTranscriptSource.builder().applyMutation(s3BucketTranscriptSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3BucketTranscriptSource s3BucketTranscriptSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptSourceSetting model) {
            s3BucketTranscriptSource(model.s3BucketTranscriptSource);
        }

        public final S3BucketTranscriptSource.Builder getS3BucketTranscriptSource() {
            return s3BucketTranscriptSource != null ? s3BucketTranscriptSource.toBuilder() : null;
        }

        public final void setS3BucketTranscriptSource(S3BucketTranscriptSource.BuilderImpl s3BucketTranscriptSource) {
            this.s3BucketTranscriptSource = s3BucketTranscriptSource != null ? s3BucketTranscriptSource.build() : null;
        }

        @Override
        public final Builder s3BucketTranscriptSource(S3BucketTranscriptSource s3BucketTranscriptSource) {
            this.s3BucketTranscriptSource = s3BucketTranscriptSource;
            return this;
        }

        @Override
        public TranscriptSourceSetting build() {
            return new TranscriptSourceSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
