/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TestSetSlotDiscrepancyListCopier {
    static List<TestSetSlotDiscrepancyItem> copy(Collection<? extends TestSetSlotDiscrepancyItem> testSetSlotDiscrepancyListParam) {
        List<TestSetSlotDiscrepancyItem> list;
        if (testSetSlotDiscrepancyListParam == null || testSetSlotDiscrepancyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestSetSlotDiscrepancyItem> modifiableList = new ArrayList<>(testSetSlotDiscrepancyListParam.size());
            testSetSlotDiscrepancyListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestSetSlotDiscrepancyItem> copyFromBuilder(
            Collection<? extends TestSetSlotDiscrepancyItem.Builder> testSetSlotDiscrepancyListParam) {
        List<TestSetSlotDiscrepancyItem> list;
        if (testSetSlotDiscrepancyListParam == null || testSetSlotDiscrepancyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestSetSlotDiscrepancyItem> modifiableList = new ArrayList<>(testSetSlotDiscrepancyListParam.size());
            testSetSlotDiscrepancyListParam.forEach(entry -> {
                TestSetSlotDiscrepancyItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestSetSlotDiscrepancyItem.Builder> copyToBuilder(
            Collection<? extends TestSetSlotDiscrepancyItem> testSetSlotDiscrepancyListParam) {
        List<TestSetSlotDiscrepancyItem.Builder> list;
        if (testSetSlotDiscrepancyListParam == null || testSetSlotDiscrepancyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestSetSlotDiscrepancyItem.Builder> modifiableList = new ArrayList<>(testSetSlotDiscrepancyListParam.size());
            testSetSlotDiscrepancyListParam.forEach(entry -> {
                TestSetSlotDiscrepancyItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
