/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the test execution, grouped by type of results. See <a
 * href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result details"&gt;Test
 * results details</a> for details about different types of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestExecutionResultItems implements SdkPojo, Serializable,
        ToCopyableBuilder<TestExecutionResultItems.Builder, TestExecutionResultItems> {
    private static final SdkField<OverallTestResults> OVERALL_TEST_RESULTS_FIELD = SdkField
            .<OverallTestResults> builder(MarshallingType.SDK_POJO).memberName("overallTestResults")
            .getter(getter(TestExecutionResultItems::overallTestResults)).setter(setter(Builder::overallTestResults))
            .constructor(OverallTestResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overallTestResults").build())
            .build();

    private static final SdkField<ConversationLevelTestResults> CONVERSATION_LEVEL_TEST_RESULTS_FIELD = SdkField
            .<ConversationLevelTestResults> builder(MarshallingType.SDK_POJO)
            .memberName("conversationLevelTestResults")
            .getter(getter(TestExecutionResultItems::conversationLevelTestResults))
            .setter(setter(Builder::conversationLevelTestResults))
            .constructor(ConversationLevelTestResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLevelTestResults")
                    .build()).build();

    private static final SdkField<IntentClassificationTestResults> INTENT_CLASSIFICATION_TEST_RESULTS_FIELD = SdkField
            .<IntentClassificationTestResults> builder(MarshallingType.SDK_POJO)
            .memberName("intentClassificationTestResults")
            .getter(getter(TestExecutionResultItems::intentClassificationTestResults))
            .setter(setter(Builder::intentClassificationTestResults))
            .constructor(IntentClassificationTestResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClassificationTestResults")
                    .build()).build();

    private static final SdkField<IntentLevelSlotResolutionTestResults> INTENT_LEVEL_SLOT_RESOLUTION_TEST_RESULTS_FIELD = SdkField
            .<IntentLevelSlotResolutionTestResults> builder(MarshallingType.SDK_POJO)
            .memberName("intentLevelSlotResolutionTestResults")
            .getter(getter(TestExecutionResultItems::intentLevelSlotResolutionTestResults))
            .setter(setter(Builder::intentLevelSlotResolutionTestResults))
            .constructor(IntentLevelSlotResolutionTestResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("intentLevelSlotResolutionTestResults").build()).build();

    private static final SdkField<UtteranceLevelTestResults> UTTERANCE_LEVEL_TEST_RESULTS_FIELD = SdkField
            .<UtteranceLevelTestResults> builder(MarshallingType.SDK_POJO).memberName("utteranceLevelTestResults")
            .getter(getter(TestExecutionResultItems::utteranceLevelTestResults))
            .setter(setter(Builder::utteranceLevelTestResults)).constructor(UtteranceLevelTestResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceLevelTestResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_TEST_RESULTS_FIELD,
            CONVERSATION_LEVEL_TEST_RESULTS_FIELD, INTENT_CLASSIFICATION_TEST_RESULTS_FIELD,
            INTENT_LEVEL_SLOT_RESOLUTION_TEST_RESULTS_FIELD, UTTERANCE_LEVEL_TEST_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OverallTestResults overallTestResults;

    private final ConversationLevelTestResults conversationLevelTestResults;

    private final IntentClassificationTestResults intentClassificationTestResults;

    private final IntentLevelSlotResolutionTestResults intentLevelSlotResolutionTestResults;

    private final UtteranceLevelTestResults utteranceLevelTestResults;

    private TestExecutionResultItems(BuilderImpl builder) {
        this.overallTestResults = builder.overallTestResults;
        this.conversationLevelTestResults = builder.conversationLevelTestResults;
        this.intentClassificationTestResults = builder.intentClassificationTestResults;
        this.intentLevelSlotResolutionTestResults = builder.intentLevelSlotResolutionTestResults;
        this.utteranceLevelTestResults = builder.utteranceLevelTestResults;
    }

    /**
     * <p>
     * Overall results for the test execution, including the breakdown of conversations and single-input utterances.
     * </p>
     * 
     * @return Overall results for the test execution, including the breakdown of conversations and single-input
     *         utterances.
     */
    public final OverallTestResults overallTestResults() {
        return overallTestResults;
    }

    /**
     * <p>
     * Results related to conversations in the test set, including metrics about success and failure of conversations
     * and intent and slot failures.
     * </p>
     * 
     * @return Results related to conversations in the test set, including metrics about success and failure of
     *         conversations and intent and slot failures.
     */
    public final ConversationLevelTestResults conversationLevelTestResults() {
        return conversationLevelTestResults;
    }

    /**
     * <p>
     * Intent recognition results aggregated by intent name. The aggregated results contain success and failure rates of
     * intent recognition, speech transcriptions, and end-to-end conversations.
     * </p>
     * 
     * @return Intent recognition results aggregated by intent name. The aggregated results contain success and failure
     *         rates of intent recognition, speech transcriptions, and end-to-end conversations.
     */
    public final IntentClassificationTestResults intentClassificationTestResults() {
        return intentClassificationTestResults;
    }

    /**
     * <p>
     * Slot resolution results aggregated by intent and slot name. The aggregated results contain success and failure
     * rates of slot resolution, speech transcriptions, and end-to-end conversations
     * </p>
     * 
     * @return Slot resolution results aggregated by intent and slot name. The aggregated results contain success and
     *         failure rates of slot resolution, speech transcriptions, and end-to-end conversations
     */
    public final IntentLevelSlotResolutionTestResults intentLevelSlotResolutionTestResults() {
        return intentLevelSlotResolutionTestResults;
    }

    /**
     * <p>
     * Results related to utterances in the test set.
     * </p>
     * 
     * @return Results related to utterances in the test set.
     */
    public final UtteranceLevelTestResults utteranceLevelTestResults() {
        return utteranceLevelTestResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overallTestResults());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLevelTestResults());
        hashCode = 31 * hashCode + Objects.hashCode(intentClassificationTestResults());
        hashCode = 31 * hashCode + Objects.hashCode(intentLevelSlotResolutionTestResults());
        hashCode = 31 * hashCode + Objects.hashCode(utteranceLevelTestResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestExecutionResultItems)) {
            return false;
        }
        TestExecutionResultItems other = (TestExecutionResultItems) obj;
        return Objects.equals(overallTestResults(), other.overallTestResults())
                && Objects.equals(conversationLevelTestResults(), other.conversationLevelTestResults())
                && Objects.equals(intentClassificationTestResults(), other.intentClassificationTestResults())
                && Objects.equals(intentLevelSlotResolutionTestResults(), other.intentLevelSlotResolutionTestResults())
                && Objects.equals(utteranceLevelTestResults(), other.utteranceLevelTestResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestExecutionResultItems").add("OverallTestResults", overallTestResults())
                .add("ConversationLevelTestResults", conversationLevelTestResults())
                .add("IntentClassificationTestResults", intentClassificationTestResults())
                .add("IntentLevelSlotResolutionTestResults", intentLevelSlotResolutionTestResults())
                .add("UtteranceLevelTestResults", utteranceLevelTestResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overallTestResults":
            return Optional.ofNullable(clazz.cast(overallTestResults()));
        case "conversationLevelTestResults":
            return Optional.ofNullable(clazz.cast(conversationLevelTestResults()));
        case "intentClassificationTestResults":
            return Optional.ofNullable(clazz.cast(intentClassificationTestResults()));
        case "intentLevelSlotResolutionTestResults":
            return Optional.ofNullable(clazz.cast(intentLevelSlotResolutionTestResults()));
        case "utteranceLevelTestResults":
            return Optional.ofNullable(clazz.cast(utteranceLevelTestResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("overallTestResults", OVERALL_TEST_RESULTS_FIELD);
        map.put("conversationLevelTestResults", CONVERSATION_LEVEL_TEST_RESULTS_FIELD);
        map.put("intentClassificationTestResults", INTENT_CLASSIFICATION_TEST_RESULTS_FIELD);
        map.put("intentLevelSlotResolutionTestResults", INTENT_LEVEL_SLOT_RESOLUTION_TEST_RESULTS_FIELD);
        map.put("utteranceLevelTestResults", UTTERANCE_LEVEL_TEST_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestExecutionResultItems, T> g) {
        return obj -> g.apply((TestExecutionResultItems) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestExecutionResultItems> {
        /**
         * <p>
         * Overall results for the test execution, including the breakdown of conversations and single-input utterances.
         * </p>
         * 
         * @param overallTestResults
         *        Overall results for the test execution, including the breakdown of conversations and single-input
         *        utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallTestResults(OverallTestResults overallTestResults);

        /**
         * <p>
         * Overall results for the test execution, including the breakdown of conversations and single-input utterances.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverallTestResults.Builder} avoiding the
         * need to create one manually via {@link OverallTestResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverallTestResults.Builder#build()} is called immediately and its
         * result is passed to {@link #overallTestResults(OverallTestResults)}.
         * 
         * @param overallTestResults
         *        a consumer that will call methods on {@link OverallTestResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overallTestResults(OverallTestResults)
         */
        default Builder overallTestResults(Consumer<OverallTestResults.Builder> overallTestResults) {
            return overallTestResults(OverallTestResults.builder().applyMutation(overallTestResults).build());
        }

        /**
         * <p>
         * Results related to conversations in the test set, including metrics about success and failure of
         * conversations and intent and slot failures.
         * </p>
         * 
         * @param conversationLevelTestResults
         *        Results related to conversations in the test set, including metrics about success and failure of
         *        conversations and intent and slot failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLevelTestResults(ConversationLevelTestResults conversationLevelTestResults);

        /**
         * <p>
         * Results related to conversations in the test set, including metrics about success and failure of
         * conversations and intent and slot failures.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLevelTestResults.Builder}
         * avoiding the need to create one manually via {@link ConversationLevelTestResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLevelTestResults.Builder#build()} is called
         * immediately and its result is passed to {@link #conversationLevelTestResults(ConversationLevelTestResults)}.
         * 
         * @param conversationLevelTestResults
         *        a consumer that will call methods on {@link ConversationLevelTestResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLevelTestResults(ConversationLevelTestResults)
         */
        default Builder conversationLevelTestResults(Consumer<ConversationLevelTestResults.Builder> conversationLevelTestResults) {
            return conversationLevelTestResults(ConversationLevelTestResults.builder()
                    .applyMutation(conversationLevelTestResults).build());
        }

        /**
         * <p>
         * Intent recognition results aggregated by intent name. The aggregated results contain success and failure
         * rates of intent recognition, speech transcriptions, and end-to-end conversations.
         * </p>
         * 
         * @param intentClassificationTestResults
         *        Intent recognition results aggregated by intent name. The aggregated results contain success and
         *        failure rates of intent recognition, speech transcriptions, and end-to-end conversations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClassificationTestResults(IntentClassificationTestResults intentClassificationTestResults);

        /**
         * <p>
         * Intent recognition results aggregated by intent name. The aggregated results contain success and failure
         * rates of intent recognition, speech transcriptions, and end-to-end conversations.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentClassificationTestResults.Builder}
         * avoiding the need to create one manually via {@link IntentClassificationTestResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentClassificationTestResults.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #intentClassificationTestResults(IntentClassificationTestResults)}.
         * 
         * @param intentClassificationTestResults
         *        a consumer that will call methods on {@link IntentClassificationTestResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClassificationTestResults(IntentClassificationTestResults)
         */
        default Builder intentClassificationTestResults(
                Consumer<IntentClassificationTestResults.Builder> intentClassificationTestResults) {
            return intentClassificationTestResults(IntentClassificationTestResults.builder()
                    .applyMutation(intentClassificationTestResults).build());
        }

        /**
         * <p>
         * Slot resolution results aggregated by intent and slot name. The aggregated results contain success and
         * failure rates of slot resolution, speech transcriptions, and end-to-end conversations
         * </p>
         * 
         * @param intentLevelSlotResolutionTestResults
         *        Slot resolution results aggregated by intent and slot name. The aggregated results contain success and
         *        failure rates of slot resolution, speech transcriptions, and end-to-end conversations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentLevelSlotResolutionTestResults(IntentLevelSlotResolutionTestResults intentLevelSlotResolutionTestResults);

        /**
         * <p>
         * Slot resolution results aggregated by intent and slot name. The aggregated results contain success and
         * failure rates of slot resolution, speech transcriptions, and end-to-end conversations
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IntentLevelSlotResolutionTestResults.Builder} avoiding the need to create one manually via
         * {@link IntentLevelSlotResolutionTestResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentLevelSlotResolutionTestResults.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #intentLevelSlotResolutionTestResults(IntentLevelSlotResolutionTestResults)}.
         * 
         * @param intentLevelSlotResolutionTestResults
         *        a consumer that will call methods on {@link IntentLevelSlotResolutionTestResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentLevelSlotResolutionTestResults(IntentLevelSlotResolutionTestResults)
         */
        default Builder intentLevelSlotResolutionTestResults(
                Consumer<IntentLevelSlotResolutionTestResults.Builder> intentLevelSlotResolutionTestResults) {
            return intentLevelSlotResolutionTestResults(IntentLevelSlotResolutionTestResults.builder()
                    .applyMutation(intentLevelSlotResolutionTestResults).build());
        }

        /**
         * <p>
         * Results related to utterances in the test set.
         * </p>
         * 
         * @param utteranceLevelTestResults
         *        Results related to utterances in the test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utteranceLevelTestResults(UtteranceLevelTestResults utteranceLevelTestResults);

        /**
         * <p>
         * Results related to utterances in the test set.
         * </p>
         * This is a convenience method that creates an instance of the {@link UtteranceLevelTestResults.Builder}
         * avoiding the need to create one manually via {@link UtteranceLevelTestResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UtteranceLevelTestResults.Builder#build()} is called immediately
         * and its result is passed to {@link #utteranceLevelTestResults(UtteranceLevelTestResults)}.
         * 
         * @param utteranceLevelTestResults
         *        a consumer that will call methods on {@link UtteranceLevelTestResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utteranceLevelTestResults(UtteranceLevelTestResults)
         */
        default Builder utteranceLevelTestResults(Consumer<UtteranceLevelTestResults.Builder> utteranceLevelTestResults) {
            return utteranceLevelTestResults(UtteranceLevelTestResults.builder().applyMutation(utteranceLevelTestResults).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OverallTestResults overallTestResults;

        private ConversationLevelTestResults conversationLevelTestResults;

        private IntentClassificationTestResults intentClassificationTestResults;

        private IntentLevelSlotResolutionTestResults intentLevelSlotResolutionTestResults;

        private UtteranceLevelTestResults utteranceLevelTestResults;

        private BuilderImpl() {
        }

        private BuilderImpl(TestExecutionResultItems model) {
            overallTestResults(model.overallTestResults);
            conversationLevelTestResults(model.conversationLevelTestResults);
            intentClassificationTestResults(model.intentClassificationTestResults);
            intentLevelSlotResolutionTestResults(model.intentLevelSlotResolutionTestResults);
            utteranceLevelTestResults(model.utteranceLevelTestResults);
        }

        public final OverallTestResults.Builder getOverallTestResults() {
            return overallTestResults != null ? overallTestResults.toBuilder() : null;
        }

        public final void setOverallTestResults(OverallTestResults.BuilderImpl overallTestResults) {
            this.overallTestResults = overallTestResults != null ? overallTestResults.build() : null;
        }

        @Override
        public final Builder overallTestResults(OverallTestResults overallTestResults) {
            this.overallTestResults = overallTestResults;
            return this;
        }

        public final ConversationLevelTestResults.Builder getConversationLevelTestResults() {
            return conversationLevelTestResults != null ? conversationLevelTestResults.toBuilder() : null;
        }

        public final void setConversationLevelTestResults(ConversationLevelTestResults.BuilderImpl conversationLevelTestResults) {
            this.conversationLevelTestResults = conversationLevelTestResults != null ? conversationLevelTestResults.build()
                    : null;
        }

        @Override
        public final Builder conversationLevelTestResults(ConversationLevelTestResults conversationLevelTestResults) {
            this.conversationLevelTestResults = conversationLevelTestResults;
            return this;
        }

        public final IntentClassificationTestResults.Builder getIntentClassificationTestResults() {
            return intentClassificationTestResults != null ? intentClassificationTestResults.toBuilder() : null;
        }

        public final void setIntentClassificationTestResults(
                IntentClassificationTestResults.BuilderImpl intentClassificationTestResults) {
            this.intentClassificationTestResults = intentClassificationTestResults != null ? intentClassificationTestResults
                    .build() : null;
        }

        @Override
        public final Builder intentClassificationTestResults(IntentClassificationTestResults intentClassificationTestResults) {
            this.intentClassificationTestResults = intentClassificationTestResults;
            return this;
        }

        public final IntentLevelSlotResolutionTestResults.Builder getIntentLevelSlotResolutionTestResults() {
            return intentLevelSlotResolutionTestResults != null ? intentLevelSlotResolutionTestResults.toBuilder() : null;
        }

        public final void setIntentLevelSlotResolutionTestResults(
                IntentLevelSlotResolutionTestResults.BuilderImpl intentLevelSlotResolutionTestResults) {
            this.intentLevelSlotResolutionTestResults = intentLevelSlotResolutionTestResults != null ? intentLevelSlotResolutionTestResults
                    .build() : null;
        }

        @Override
        public final Builder intentLevelSlotResolutionTestResults(
                IntentLevelSlotResolutionTestResults intentLevelSlotResolutionTestResults) {
            this.intentLevelSlotResolutionTestResults = intentLevelSlotResolutionTestResults;
            return this;
        }

        public final UtteranceLevelTestResults.Builder getUtteranceLevelTestResults() {
            return utteranceLevelTestResults != null ? utteranceLevelTestResults.toBuilder() : null;
        }

        public final void setUtteranceLevelTestResults(UtteranceLevelTestResults.BuilderImpl utteranceLevelTestResults) {
            this.utteranceLevelTestResults = utteranceLevelTestResults != null ? utteranceLevelTestResults.build() : null;
        }

        @Override
        public final Builder utteranceLevelTestResults(UtteranceLevelTestResults utteranceLevelTestResults) {
            this.utteranceLevelTestResults = utteranceLevelTestResults;
            return this;
        }

        @Override
        public TestExecutionResultItems build() {
            return new TestExecutionResultItems(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
