/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the method by which to filter the results of the test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestExecutionResultFilterBy implements SdkPojo, Serializable,
        ToCopyableBuilder<TestExecutionResultFilterBy.Builder, TestExecutionResultFilterBy> {
    private static final SdkField<String> RESULT_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultTypeFilter").getter(getter(TestExecutionResultFilterBy::resultTypeFilterAsString))
            .setter(setter(Builder::resultTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultTypeFilter").build()).build();

    private static final SdkField<ConversationLevelTestResultsFilterBy> CONVERSATION_LEVEL_TEST_RESULTS_FILTER_BY_FIELD = SdkField
            .<ConversationLevelTestResultsFilterBy> builder(MarshallingType.SDK_POJO)
            .memberName("conversationLevelTestResultsFilterBy")
            .getter(getter(TestExecutionResultFilterBy::conversationLevelTestResultsFilterBy))
            .setter(setter(Builder::conversationLevelTestResultsFilterBy))
            .constructor(ConversationLevelTestResultsFilterBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("conversationLevelTestResultsFilterBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_TYPE_FILTER_FIELD,
            CONVERSATION_LEVEL_TEST_RESULTS_FILTER_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resultTypeFilter;

    private final ConversationLevelTestResultsFilterBy conversationLevelTestResultsFilterBy;

    private TestExecutionResultFilterBy(BuilderImpl builder) {
        this.resultTypeFilter = builder.resultTypeFilter;
        this.conversationLevelTestResultsFilterBy = builder.conversationLevelTestResultsFilterBy;
    }

    /**
     * <p>
     * Specifies which results to filter. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
     * details"&gt;Test results details</a> for details about different types of results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultTypeFilter}
     * will return {@link TestResultTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultTypeFilterAsString}.
     * </p>
     * 
     * @return Specifies which results to filter. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
     *         details"&gt;Test results details</a> for details about different types of results.
     * @see TestResultTypeFilter
     */
    public final TestResultTypeFilter resultTypeFilter() {
        return TestResultTypeFilter.fromValue(resultTypeFilter);
    }

    /**
     * <p>
     * Specifies which results to filter. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
     * details"&gt;Test results details</a> for details about different types of results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultTypeFilter}
     * will return {@link TestResultTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultTypeFilterAsString}.
     * </p>
     * 
     * @return Specifies which results to filter. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
     *         details"&gt;Test results details</a> for details about different types of results.
     * @see TestResultTypeFilter
     */
    public final String resultTypeFilterAsString() {
        return resultTypeFilter;
    }

    /**
     * <p>
     * Contains information about the method for filtering Conversation level test results.
     * </p>
     * 
     * @return Contains information about the method for filtering Conversation level test results.
     */
    public final ConversationLevelTestResultsFilterBy conversationLevelTestResultsFilterBy() {
        return conversationLevelTestResultsFilterBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conversationLevelTestResultsFilterBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestExecutionResultFilterBy)) {
            return false;
        }
        TestExecutionResultFilterBy other = (TestExecutionResultFilterBy) obj;
        return Objects.equals(resultTypeFilterAsString(), other.resultTypeFilterAsString())
                && Objects.equals(conversationLevelTestResultsFilterBy(), other.conversationLevelTestResultsFilterBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestExecutionResultFilterBy").add("ResultTypeFilter", resultTypeFilterAsString())
                .add("ConversationLevelTestResultsFilterBy", conversationLevelTestResultsFilterBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resultTypeFilter":
            return Optional.ofNullable(clazz.cast(resultTypeFilterAsString()));
        case "conversationLevelTestResultsFilterBy":
            return Optional.ofNullable(clazz.cast(conversationLevelTestResultsFilterBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resultTypeFilter", RESULT_TYPE_FILTER_FIELD);
        map.put("conversationLevelTestResultsFilterBy", CONVERSATION_LEVEL_TEST_RESULTS_FILTER_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestExecutionResultFilterBy, T> g) {
        return obj -> g.apply((TestExecutionResultFilterBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestExecutionResultFilterBy> {
        /**
         * <p>
         * Specifies which results to filter. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
         * details"&gt;Test results details</a> for details about different types of results.
         * </p>
         * 
         * @param resultTypeFilter
         *        Specifies which results to filter. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
         *        details"&gt;Test results details</a> for details about different types of results.
         * @see TestResultTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultTypeFilter
         */
        Builder resultTypeFilter(String resultTypeFilter);

        /**
         * <p>
         * Specifies which results to filter. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
         * details"&gt;Test results details</a> for details about different types of results.
         * </p>
         * 
         * @param resultTypeFilter
         *        Specifies which results to filter. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result
         *        details"&gt;Test results details</a> for details about different types of results.
         * @see TestResultTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultTypeFilter
         */
        Builder resultTypeFilter(TestResultTypeFilter resultTypeFilter);

        /**
         * <p>
         * Contains information about the method for filtering Conversation level test results.
         * </p>
         * 
         * @param conversationLevelTestResultsFilterBy
         *        Contains information about the method for filtering Conversation level test results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLevelTestResultsFilterBy(ConversationLevelTestResultsFilterBy conversationLevelTestResultsFilterBy);

        /**
         * <p>
         * Contains information about the method for filtering Conversation level test results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConversationLevelTestResultsFilterBy.Builder} avoiding the need to create one manually via
         * {@link ConversationLevelTestResultsFilterBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLevelTestResultsFilterBy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #conversationLevelTestResultsFilterBy(ConversationLevelTestResultsFilterBy)}.
         * 
         * @param conversationLevelTestResultsFilterBy
         *        a consumer that will call methods on {@link ConversationLevelTestResultsFilterBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLevelTestResultsFilterBy(ConversationLevelTestResultsFilterBy)
         */
        default Builder conversationLevelTestResultsFilterBy(
                Consumer<ConversationLevelTestResultsFilterBy.Builder> conversationLevelTestResultsFilterBy) {
            return conversationLevelTestResultsFilterBy(ConversationLevelTestResultsFilterBy.builder()
                    .applyMutation(conversationLevelTestResultsFilterBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resultTypeFilter;

        private ConversationLevelTestResultsFilterBy conversationLevelTestResultsFilterBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TestExecutionResultFilterBy model) {
            resultTypeFilter(model.resultTypeFilter);
            conversationLevelTestResultsFilterBy(model.conversationLevelTestResultsFilterBy);
        }

        public final String getResultTypeFilter() {
            return resultTypeFilter;
        }

        public final void setResultTypeFilter(String resultTypeFilter) {
            this.resultTypeFilter = resultTypeFilter;
        }

        @Override
        public final Builder resultTypeFilter(String resultTypeFilter) {
            this.resultTypeFilter = resultTypeFilter;
            return this;
        }

        @Override
        public final Builder resultTypeFilter(TestResultTypeFilter resultTypeFilter) {
            this.resultTypeFilter(resultTypeFilter == null ? null : resultTypeFilter.toString());
            return this;
        }

        public final ConversationLevelTestResultsFilterBy.Builder getConversationLevelTestResultsFilterBy() {
            return conversationLevelTestResultsFilterBy != null ? conversationLevelTestResultsFilterBy.toBuilder() : null;
        }

        public final void setConversationLevelTestResultsFilterBy(
                ConversationLevelTestResultsFilterBy.BuilderImpl conversationLevelTestResultsFilterBy) {
            this.conversationLevelTestResultsFilterBy = conversationLevelTestResultsFilterBy != null ? conversationLevelTestResultsFilterBy
                    .build() : null;
        }

        @Override
        public final Builder conversationLevelTestResultsFilterBy(
                ConversationLevelTestResultsFilterBy conversationLevelTestResultsFilterBy) {
            this.conversationLevelTestResultsFilterBy = conversationLevelTestResultsFilterBy;
            return this;
        }

        @Override
        public TestExecutionResultFilterBy build() {
            return new TestExecutionResultFilterBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
