/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<StartImportResponse.Builder, StartImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(StartImportResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ImportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(StartImportResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ImportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(StartImportResponse::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(StartImportResponse::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(StartImportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, MERGE_STRATEGY_FIELD, IMPORT_STATUS_FIELD, CREATION_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String importId;

    private final ImportResourceSpecification resourceSpecification;

    private final String mergeStrategy;

    private final String importStatus;

    private final Instant creationDateTime;

    private StartImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.mergeStrategy = builder.mergeStrategy;
        this.importStatus = builder.importStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * A unique identifier for the import.
     * </p>
     * 
     * @return A unique identifier for the import.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * The parameters used when importing the resource.
     * </p>
     * 
     * @return The parameters used when importing the resource.
     */
    public final ImportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The strategy used when there was a name conflict between the imported resource and an existing resource. When the
     * merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when there was a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The strategy used when there was a name conflict between the imported resource and an existing resource. When the
     * merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when there was a name conflict between the imported resource and an existing resource.
     *         When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the
     *         import fails.
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
     * vocabulary is ready to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
     *         vocabulary is ready to use.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
     * vocabulary is ready to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
     *         vocabulary is ready to use.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * The date and time that the import request was created.
     * </p>
     * 
     * @return The date and time that the import request was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportResponse)) {
            return false;
        }
        StartImportResponse other = (StartImportResponse) obj;
        return Objects.equals(importId(), other.importId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportResponse").add("ImportId", importId())
                .add("ResourceSpecification", resourceSpecification()).add("MergeStrategy", mergeStrategyAsString())
                .add("ImportStatus", importStatusAsString()).add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("mergeStrategy", MERGE_STRATEGY_FIELD);
        map.put("importStatus", IMPORT_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportResponse, T> g) {
        return obj -> g.apply((StartImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, StartImportResponse> {
        /**
         * <p>
         * A unique identifier for the import.
         * </p>
         * 
         * @param importId
         *        A unique identifier for the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The parameters used when importing the resource.
         * </p>
         * 
         * @param resourceSpecification
         *        The parameters used when importing the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ImportResourceSpecification resourceSpecification);

        /**
         * <p>
         * The parameters used when importing the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportResourceSpecification.Builder}
         * avoiding the need to create one manually via {@link ImportResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ImportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ImportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ImportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ImportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The strategy used when there was a name conflict between the imported resource and an existing resource. When
         * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used when there was a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The strategy used when there was a name conflict between the imported resource and an existing resource. When
         * the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import
         * fails.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used when there was a name conflict between the imported resource and an existing
         *        resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not
         *        overwritten and the import fails.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
         * vocabulary is ready to use.
         * </p>
         * 
         * @param importStatus
         *        The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or
         *        custom vocabulary is ready to use.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom
         * vocabulary is ready to use.
         * </p>
         * 
         * @param importStatus
         *        The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or
         *        custom vocabulary is ready to use.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * The date and time that the import request was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the import request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String importId;

        private ImportResourceSpecification resourceSpecification;

        private String mergeStrategy;

        private String importStatus;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportResponse model) {
            super(model);
            importId(model.importId);
            resourceSpecification(model.resourceSpecification);
            mergeStrategy(model.mergeStrategy);
            importStatus(model.importStatus);
            creationDateTime(model.creationDateTime);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public StartImportResponse build() {
            return new StartImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
