/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that control how Amazon Lex processes and recognizes speech input from users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeechRecognitionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeechRecognitionSettings.Builder, SpeechRecognitionSettings> {
    private static final SdkField<String> SPEECH_MODEL_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("speechModelPreference").getter(getter(SpeechRecognitionSettings::speechModelPreferenceAsString))
            .setter(setter(Builder::speechModelPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechModelPreference").build())
            .build();

    private static final SdkField<SpeechModelConfig> SPEECH_MODEL_CONFIG_FIELD = SdkField
            .<SpeechModelConfig> builder(MarshallingType.SDK_POJO).memberName("speechModelConfig")
            .getter(getter(SpeechRecognitionSettings::speechModelConfig)).setter(setter(Builder::speechModelConfig))
            .constructor(SpeechModelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechModelConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEECH_MODEL_PREFERENCE_FIELD,
            SPEECH_MODEL_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String speechModelPreference;

    private final SpeechModelConfig speechModelConfig;

    private SpeechRecognitionSettings(BuilderImpl builder) {
        this.speechModelPreference = builder.speechModelPreference;
        this.speechModelConfig = builder.speechModelConfig;
    }

    /**
     * <p>
     * The speech-to-text model to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechModelPreference} will return {@link SpeechModelPreference#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #speechModelPreferenceAsString}.
     * </p>
     * 
     * @return The speech-to-text model to use.
     * @see SpeechModelPreference
     */
    public final SpeechModelPreference speechModelPreference() {
        return SpeechModelPreference.fromValue(speechModelPreference);
    }

    /**
     * <p>
     * The speech-to-text model to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechModelPreference} will return {@link SpeechModelPreference#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #speechModelPreferenceAsString}.
     * </p>
     * 
     * @return The speech-to-text model to use.
     * @see SpeechModelPreference
     */
    public final String speechModelPreferenceAsString() {
        return speechModelPreference;
    }

    /**
     * <p>
     * Configuration settings for the selected speech-to-text model.
     * </p>
     * 
     * @return Configuration settings for the selected speech-to-text model.
     */
    public final SpeechModelConfig speechModelConfig() {
        return speechModelConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(speechModelPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speechModelConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeechRecognitionSettings)) {
            return false;
        }
        SpeechRecognitionSettings other = (SpeechRecognitionSettings) obj;
        return Objects.equals(speechModelPreferenceAsString(), other.speechModelPreferenceAsString())
                && Objects.equals(speechModelConfig(), other.speechModelConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeechRecognitionSettings").add("SpeechModelPreference", speechModelPreferenceAsString())
                .add("SpeechModelConfig", speechModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "speechModelPreference":
            return Optional.ofNullable(clazz.cast(speechModelPreferenceAsString()));
        case "speechModelConfig":
            return Optional.ofNullable(clazz.cast(speechModelConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("speechModelPreference", SPEECH_MODEL_PREFERENCE_FIELD);
        map.put("speechModelConfig", SPEECH_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpeechRecognitionSettings, T> g) {
        return obj -> g.apply((SpeechRecognitionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeechRecognitionSettings> {
        /**
         * <p>
         * The speech-to-text model to use.
         * </p>
         * 
         * @param speechModelPreference
         *        The speech-to-text model to use.
         * @see SpeechModelPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechModelPreference
         */
        Builder speechModelPreference(String speechModelPreference);

        /**
         * <p>
         * The speech-to-text model to use.
         * </p>
         * 
         * @param speechModelPreference
         *        The speech-to-text model to use.
         * @see SpeechModelPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechModelPreference
         */
        Builder speechModelPreference(SpeechModelPreference speechModelPreference);

        /**
         * <p>
         * Configuration settings for the selected speech-to-text model.
         * </p>
         * 
         * @param speechModelConfig
         *        Configuration settings for the selected speech-to-text model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechModelConfig(SpeechModelConfig speechModelConfig);

        /**
         * <p>
         * Configuration settings for the selected speech-to-text model.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpeechModelConfig.Builder} avoiding the
         * need to create one manually via {@link SpeechModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeechModelConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #speechModelConfig(SpeechModelConfig)}.
         * 
         * @param speechModelConfig
         *        a consumer that will call methods on {@link SpeechModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speechModelConfig(SpeechModelConfig)
         */
        default Builder speechModelConfig(Consumer<SpeechModelConfig.Builder> speechModelConfig) {
            return speechModelConfig(SpeechModelConfig.builder().applyMutation(speechModelConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String speechModelPreference;

        private SpeechModelConfig speechModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeechRecognitionSettings model) {
            speechModelPreference(model.speechModelPreference);
            speechModelConfig(model.speechModelConfig);
        }

        public final String getSpeechModelPreference() {
            return speechModelPreference;
        }

        public final void setSpeechModelPreference(String speechModelPreference) {
            this.speechModelPreference = speechModelPreference;
        }

        @Override
        public final Builder speechModelPreference(String speechModelPreference) {
            this.speechModelPreference = speechModelPreference;
            return this;
        }

        @Override
        public final Builder speechModelPreference(SpeechModelPreference speechModelPreference) {
            this.speechModelPreference(speechModelPreference == null ? null : speechModelPreference.toString());
            return this;
        }

        public final SpeechModelConfig.Builder getSpeechModelConfig() {
            return speechModelConfig != null ? speechModelConfig.toBuilder() : null;
        }

        public final void setSpeechModelConfig(SpeechModelConfig.BuilderImpl speechModelConfig) {
            this.speechModelConfig = speechModelConfig != null ? speechModelConfig.build() : null;
        }

        @Override
        public final Builder speechModelConfig(SpeechModelConfig speechModelConfig) {
            this.speechModelConfig = speechModelConfig;
            return this;
        }

        @Override
        public SpeechRecognitionSettings build() {
            return new SpeechRecognitionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
