/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings that define which speech-to-text model to use for processing speech input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeechModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeechModelConfig.Builder, SpeechModelConfig> {
    private static final SdkField<DeepgramSpeechModelConfig> DEEPGRAM_CONFIG_FIELD = SdkField
            .<DeepgramSpeechModelConfig> builder(MarshallingType.SDK_POJO).memberName("deepgramConfig")
            .getter(getter(SpeechModelConfig::deepgramConfig)).setter(setter(Builder::deepgramConfig))
            .constructor(DeepgramSpeechModelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deepgramConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEEPGRAM_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DeepgramSpeechModelConfig deepgramConfig;

    private SpeechModelConfig(BuilderImpl builder) {
        this.deepgramConfig = builder.deepgramConfig;
    }

    /**
     * <p>
     * Configuration settings for using Deepgram as the speech-to-text provider.
     * </p>
     * 
     * @return Configuration settings for using Deepgram as the speech-to-text provider.
     */
    public final DeepgramSpeechModelConfig deepgramConfig() {
        return deepgramConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deepgramConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeechModelConfig)) {
            return false;
        }
        SpeechModelConfig other = (SpeechModelConfig) obj;
        return Objects.equals(deepgramConfig(), other.deepgramConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeechModelConfig").add("DeepgramConfig", deepgramConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deepgramConfig":
            return Optional.ofNullable(clazz.cast(deepgramConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deepgramConfig", DEEPGRAM_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpeechModelConfig, T> g) {
        return obj -> g.apply((SpeechModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeechModelConfig> {
        /**
         * <p>
         * Configuration settings for using Deepgram as the speech-to-text provider.
         * </p>
         * 
         * @param deepgramConfig
         *        Configuration settings for using Deepgram as the speech-to-text provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deepgramConfig(DeepgramSpeechModelConfig deepgramConfig);

        /**
         * <p>
         * Configuration settings for using Deepgram as the speech-to-text provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeepgramSpeechModelConfig.Builder}
         * avoiding the need to create one manually via {@link DeepgramSpeechModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeepgramSpeechModelConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #deepgramConfig(DeepgramSpeechModelConfig)}.
         * 
         * @param deepgramConfig
         *        a consumer that will call methods on {@link DeepgramSpeechModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deepgramConfig(DeepgramSpeechModelConfig)
         */
        default Builder deepgramConfig(Consumer<DeepgramSpeechModelConfig.Builder> deepgramConfig) {
            return deepgramConfig(DeepgramSpeechModelConfig.builder().applyMutation(deepgramConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DeepgramSpeechModelConfig deepgramConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeechModelConfig model) {
            deepgramConfig(model.deepgramConfig);
        }

        public final DeepgramSpeechModelConfig.Builder getDeepgramConfig() {
            return deepgramConfig != null ? deepgramConfig.toBuilder() : null;
        }

        public final void setDeepgramConfig(DeepgramSpeechModelConfig.BuilderImpl deepgramConfig) {
            this.deepgramConfig = deepgramConfig != null ? deepgramConfig.build() : null;
        }

        @Override
        public final Builder deepgramConfig(DeepgramSpeechModelConfig deepgramConfig) {
            this.deepgramConfig = deepgramConfig;
            return this;
        }

        @Override
        public SpeechModelConfig build() {
            return new SpeechModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
