/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Subslot specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Specifications implements SdkPojo, Serializable, ToCopyableBuilder<Specifications.Builder, Specifications> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(Specifications::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<SubSlotValueElicitationSetting> VALUE_ELICITATION_SETTING_FIELD = SdkField
            .<SubSlotValueElicitationSetting> builder(MarshallingType.SDK_POJO).memberName("valueElicitationSetting")
            .getter(getter(Specifications::valueElicitationSetting)).setter(setter(Builder::valueElicitationSetting))
            .constructor(SubSlotValueElicitationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueElicitationSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD,
            VALUE_ELICITATION_SETTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slotTypeId;

    private final SubSlotValueElicitationSetting valueElicitationSetting;

    private Specifications(BuilderImpl builder) {
        this.slotTypeId = builder.slotTypeId;
        this.valueElicitationSetting = builder.valueElicitationSetting;
    }

    /**
     * <p>
     * The unique identifier assigned to the slot type.
     * </p>
     * 
     * @return The unique identifier assigned to the slot type.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * Specifies the elicitation setting details for constituent sub slots of a composite slot.
     * </p>
     * 
     * @return Specifies the elicitation setting details for constituent sub slots of a composite slot.
     */
    public final SubSlotValueElicitationSetting valueElicitationSetting() {
        return valueElicitationSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(valueElicitationSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Specifications)) {
            return false;
        }
        Specifications other = (Specifications) obj;
        return Objects.equals(slotTypeId(), other.slotTypeId())
                && Objects.equals(valueElicitationSetting(), other.valueElicitationSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Specifications").add("SlotTypeId", slotTypeId())
                .add("ValueElicitationSetting", valueElicitationSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "valueElicitationSetting":
            return Optional.ofNullable(clazz.cast(valueElicitationSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slotTypeId", SLOT_TYPE_ID_FIELD);
        map.put("valueElicitationSetting", VALUE_ELICITATION_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Specifications, T> g) {
        return obj -> g.apply((Specifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Specifications> {
        /**
         * <p>
         * The unique identifier assigned to the slot type.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier assigned to the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * Specifies the elicitation setting details for constituent sub slots of a composite slot.
         * </p>
         * 
         * @param valueElicitationSetting
         *        Specifies the elicitation setting details for constituent sub slots of a composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueElicitationSetting(SubSlotValueElicitationSetting valueElicitationSetting);

        /**
         * <p>
         * Specifies the elicitation setting details for constituent sub slots of a composite slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubSlotValueElicitationSetting.Builder}
         * avoiding the need to create one manually via {@link SubSlotValueElicitationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubSlotValueElicitationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #valueElicitationSetting(SubSlotValueElicitationSetting)}.
         * 
         * @param valueElicitationSetting
         *        a consumer that will call methods on {@link SubSlotValueElicitationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueElicitationSetting(SubSlotValueElicitationSetting)
         */
        default Builder valueElicitationSetting(Consumer<SubSlotValueElicitationSetting.Builder> valueElicitationSetting) {
            return valueElicitationSetting(SubSlotValueElicitationSetting.builder().applyMutation(valueElicitationSetting)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String slotTypeId;

        private SubSlotValueElicitationSetting valueElicitationSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(Specifications model) {
            slotTypeId(model.slotTypeId);
            valueElicitationSetting(model.valueElicitationSetting);
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final SubSlotValueElicitationSetting.Builder getValueElicitationSetting() {
            return valueElicitationSetting != null ? valueElicitationSetting.toBuilder() : null;
        }

        public final void setValueElicitationSetting(SubSlotValueElicitationSetting.BuilderImpl valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting != null ? valueElicitationSetting.build() : null;
        }

        @Override
        public final Builder valueElicitationSetting(SubSlotValueElicitationSetting valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting;
            return this;
        }

        @Override
        public Specifications build() {
            return new Specifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
