/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A sample utterance that invokes an intent or respond to a slot elicitation prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampleUtterance implements SdkPojo, Serializable, ToCopyableBuilder<SampleUtterance.Builder, SampleUtterance> {
    private static final SdkField<String> UTTERANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("utterance").getter(getter(SampleUtterance::utterance)).setter(setter(Builder::utterance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String utterance;

    private SampleUtterance(BuilderImpl builder) {
        this.utterance = builder.utterance;
    }

    /**
     * <p>
     * The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
     * </p>
     * 
     * @return The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
     */
    public final String utterance() {
        return utterance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(utterance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleUtterance)) {
            return false;
        }
        SampleUtterance other = (SampleUtterance) obj;
        return Objects.equals(utterance(), other.utterance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampleUtterance").add("Utterance", utterance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "utterance":
            return Optional.ofNullable(clazz.cast(utterance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("utterance", UTTERANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SampleUtterance, T> g) {
        return obj -> g.apply((SampleUtterance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampleUtterance> {
        /**
         * <p>
         * The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
         * </p>
         * 
         * @param utterance
         *        The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterance(String utterance);
    }

    static final class BuilderImpl implements Builder {
        private String utterance;

        private BuilderImpl() {
        }

        private BuilderImpl(SampleUtterance model) {
            utterance(model.utterance);
        }

        public final String getUtterance() {
            return utterance;
        }

        public final void setUtterance(String utterance) {
            this.utterance = utterance;
        }

        @Override
        public final Builder utterance(String utterance) {
            this.utterance = utterance;
            return this;
        }

        @Override
        public SampleUtterance build() {
            return new SampleUtterance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
