/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a summary of a recommended intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedIntentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendedIntentSummary.Builder, RecommendedIntentSummary> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(RecommendedIntentSummary::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(RecommendedIntentSummary::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<Integer> SAMPLE_UTTERANCES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sampleUtterancesCount").getter(getter(RecommendedIntentSummary::sampleUtterancesCount))
            .setter(setter(Builder::sampleUtterancesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterancesCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD,
            INTENT_NAME_FIELD, SAMPLE_UTTERANCES_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String intentId;

    private final String intentName;

    private final Integer sampleUtterancesCount;

    private RecommendedIntentSummary(BuilderImpl builder) {
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.sampleUtterancesCount = builder.sampleUtterancesCount;
    }

    /**
     * <p>
     * The unique identifier of a recommended intent associated with the bot recommendation.
     * </p>
     * 
     * @return The unique identifier of a recommended intent associated with the bot recommendation.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The name of a recommended intent associated with the bot recommendation.
     * </p>
     * 
     * @return The name of a recommended intent associated with the bot recommendation.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The count of sample utterances of a recommended intent that is associated with a bot recommendation.
     * </p>
     * 
     * @return The count of sample utterances of a recommended intent that is associated with a bot recommendation.
     */
    public final Integer sampleUtterancesCount() {
        return sampleUtterancesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(sampleUtterancesCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedIntentSummary)) {
            return false;
        }
        RecommendedIntentSummary other = (RecommendedIntentSummary) obj;
        return Objects.equals(intentId(), other.intentId()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(sampleUtterancesCount(), other.sampleUtterancesCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedIntentSummary").add("IntentId", intentId()).add("IntentName", intentName())
                .add("SampleUtterancesCount", sampleUtterancesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "sampleUtterancesCount":
            return Optional.ofNullable(clazz.cast(sampleUtterancesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentId", INTENT_ID_FIELD);
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("sampleUtterancesCount", SAMPLE_UTTERANCES_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedIntentSummary, T> g) {
        return obj -> g.apply((RecommendedIntentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedIntentSummary> {
        /**
         * <p>
         * The unique identifier of a recommended intent associated with the bot recommendation.
         * </p>
         * 
         * @param intentId
         *        The unique identifier of a recommended intent associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The name of a recommended intent associated with the bot recommendation.
         * </p>
         * 
         * @param intentName
         *        The name of a recommended intent associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The count of sample utterances of a recommended intent that is associated with a bot recommendation.
         * </p>
         * 
         * @param sampleUtterancesCount
         *        The count of sample utterances of a recommended intent that is associated with a bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterancesCount(Integer sampleUtterancesCount);
    }

    static final class BuilderImpl implements Builder {
        private String intentId;

        private String intentName;

        private Integer sampleUtterancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedIntentSummary model) {
            intentId(model.intentId);
            intentName(model.intentName);
            sampleUtterancesCount(model.sampleUtterancesCount);
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final Integer getSampleUtterancesCount() {
            return sampleUtterancesCount;
        }

        public final void setSampleUtterancesCount(Integer sampleUtterancesCount) {
            this.sampleUtterancesCount = sampleUtterancesCount;
        }

        @Override
        public final Builder sampleUtterancesCount(Integer sampleUtterancesCount) {
            this.sampleUtterancesCount = sampleUtterancesCount;
            return this;
        }

        @Override
        public RecommendedIntentSummary build() {
            return new RecommendedIntentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
