/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the Qinconnect intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QInConnectIntentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QInConnectIntentConfiguration.Builder, QInConnectIntentConfiguration> {
    private static final SdkField<QInConnectAssistantConfiguration> Q_IN_CONNECT_ASSISTANT_CONFIGURATION_FIELD = SdkField
            .<QInConnectAssistantConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("qInConnectAssistantConfiguration")
            .getter(getter(QInConnectIntentConfiguration::qInConnectAssistantConfiguration))
            .setter(setter(Builder::qInConnectAssistantConfiguration))
            .constructor(QInConnectAssistantConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qInConnectAssistantConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(Q_IN_CONNECT_ASSISTANT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QInConnectAssistantConfiguration qInConnectAssistantConfiguration;

    private QInConnectIntentConfiguration(BuilderImpl builder) {
        this.qInConnectAssistantConfiguration = builder.qInConnectAssistantConfiguration;
    }

    /**
     * <p>
     * The Qinconnect assistant configuration details of the Qinconnect intent.
     * </p>
     * 
     * @return The Qinconnect assistant configuration details of the Qinconnect intent.
     */
    public final QInConnectAssistantConfiguration qInConnectAssistantConfiguration() {
        return qInConnectAssistantConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qInConnectAssistantConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QInConnectIntentConfiguration)) {
            return false;
        }
        QInConnectIntentConfiguration other = (QInConnectIntentConfiguration) obj;
        return Objects.equals(qInConnectAssistantConfiguration(), other.qInConnectAssistantConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QInConnectIntentConfiguration")
                .add("QInConnectAssistantConfiguration", qInConnectAssistantConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "qInConnectAssistantConfiguration":
            return Optional.ofNullable(clazz.cast(qInConnectAssistantConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("qInConnectAssistantConfiguration", Q_IN_CONNECT_ASSISTANT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QInConnectIntentConfiguration, T> g) {
        return obj -> g.apply((QInConnectIntentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QInConnectIntentConfiguration> {
        /**
         * <p>
         * The Qinconnect assistant configuration details of the Qinconnect intent.
         * </p>
         * 
         * @param qInConnectAssistantConfiguration
         *        The Qinconnect assistant configuration details of the Qinconnect intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qInConnectAssistantConfiguration(QInConnectAssistantConfiguration qInConnectAssistantConfiguration);

        /**
         * <p>
         * The Qinconnect assistant configuration details of the Qinconnect intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link QInConnectAssistantConfiguration.Builder}
         * avoiding the need to create one manually via {@link QInConnectAssistantConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QInConnectAssistantConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #qInConnectAssistantConfiguration(QInConnectAssistantConfiguration)}.
         * 
         * @param qInConnectAssistantConfiguration
         *        a consumer that will call methods on {@link QInConnectAssistantConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qInConnectAssistantConfiguration(QInConnectAssistantConfiguration)
         */
        default Builder qInConnectAssistantConfiguration(
                Consumer<QInConnectAssistantConfiguration.Builder> qInConnectAssistantConfiguration) {
            return qInConnectAssistantConfiguration(QInConnectAssistantConfiguration.builder()
                    .applyMutation(qInConnectAssistantConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QInConnectAssistantConfiguration qInConnectAssistantConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QInConnectIntentConfiguration model) {
            qInConnectAssistantConfiguration(model.qInConnectAssistantConfiguration);
        }

        public final QInConnectAssistantConfiguration.Builder getQInConnectAssistantConfiguration() {
            return qInConnectAssistantConfiguration != null ? qInConnectAssistantConfiguration.toBuilder() : null;
        }

        public final void setQInConnectAssistantConfiguration(
                QInConnectAssistantConfiguration.BuilderImpl qInConnectAssistantConfiguration) {
            this.qInConnectAssistantConfiguration = qInConnectAssistantConfiguration != null ? qInConnectAssistantConfiguration
                    .build() : null;
        }

        @Override
        public final Builder qInConnectAssistantConfiguration(QInConnectAssistantConfiguration qInConnectAssistantConfiguration) {
            this.qInConnectAssistantConfiguration = qInConnectAssistantConfiguration;
            return this;
        }

        @Override
        public QInConnectIntentConfiguration build() {
            return new QInConnectIntentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
