/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PromptAttemptsSpecificationMapCopier {
    static Map<String, PromptAttemptSpecification> copy(
            Map<String, ? extends PromptAttemptSpecification> promptAttemptsSpecificationMapParam) {
        Map<String, PromptAttemptSpecification> map;
        if (promptAttemptsSpecificationMapParam == null || promptAttemptsSpecificationMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PromptAttemptSpecification> modifiableMap = new LinkedHashMap<>(
                    promptAttemptsSpecificationMapParam.size());
            promptAttemptsSpecificationMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PromptAttemptSpecification> copyFromBuilder(
            Map<String, ? extends PromptAttemptSpecification.Builder> promptAttemptsSpecificationMapParam) {
        Map<String, PromptAttemptSpecification> map;
        if (promptAttemptsSpecificationMapParam == null || promptAttemptsSpecificationMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PromptAttemptSpecification> modifiableMap = new LinkedHashMap<>(
                    promptAttemptsSpecificationMapParam.size());
            promptAttemptsSpecificationMapParam.forEach((key, value) -> {
                PromptAttemptSpecification member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PromptAttemptSpecification.Builder> copyToBuilder(
            Map<String, ? extends PromptAttemptSpecification> promptAttemptsSpecificationMapParam) {
        Map<String, PromptAttemptSpecification.Builder> map;
        if (promptAttemptsSpecificationMapParam == null || promptAttemptsSpecificationMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PromptAttemptSpecification.Builder> modifiableMap = new LinkedHashMap<>(
                    promptAttemptsSpecificationMapParam.size());
            promptAttemptsSpecificationMapParam.forEach((key, value) -> {
                PromptAttemptSpecification.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PromptAttemptSpecification> copyEnumToString(
            Map<PromptAttempt, ? extends PromptAttemptSpecification> promptAttemptsSpecificationMapParam) {
        Map<String, PromptAttemptSpecification> map;
        if (promptAttemptsSpecificationMapParam == null || promptAttemptsSpecificationMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PromptAttemptSpecification> modifiableMap = new LinkedHashMap<>(
                    promptAttemptsSpecificationMapParam.size());
            promptAttemptsSpecificationMapParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<PromptAttempt, PromptAttemptSpecification> copyStringToEnum(
            Map<String, ? extends PromptAttemptSpecification> promptAttemptsSpecificationMapParam) {
        Map<PromptAttempt, PromptAttemptSpecification> map;
        if (promptAttemptsSpecificationMapParam == null || promptAttemptsSpecificationMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<PromptAttempt, PromptAttemptSpecification> modifiableMap = new LinkedHashMap<>(
                    promptAttemptsSpecificationMapParam.size());
            promptAttemptsSpecificationMapParam.forEach((key, value) -> {
                PromptAttempt result = PromptAttempt.fromValue(key);
                if (result != PromptAttempt.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
