/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the configuration of the Amazon OpenSearch Service database used for the
 * <code>AMAZON.QnAIntent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpensearchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpensearchConfiguration.Builder, OpensearchConfiguration> {
    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainEndpoint").getter(getter(OpensearchConfiguration::domainEndpoint))
            .setter(setter(Builder::domainEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEndpoint").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(OpensearchConfiguration::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<Boolean> EXACT_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("exactResponse").getter(getter(OpensearchConfiguration::exactResponse))
            .setter(setter(Builder::exactResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponse").build()).build();

    private static final SdkField<ExactResponseFields> EXACT_RESPONSE_FIELDS_FIELD = SdkField
            .<ExactResponseFields> builder(MarshallingType.SDK_POJO).memberName("exactResponseFields")
            .getter(getter(OpensearchConfiguration::exactResponseFields)).setter(setter(Builder::exactResponseFields))
            .constructor(ExactResponseFields::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactResponseFields").build())
            .build();

    private static final SdkField<List<String>> INCLUDE_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("includeFields")
            .getter(getter(OpensearchConfiguration::includeFields))
            .setter(setter(Builder::includeFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ENDPOINT_FIELD,
            INDEX_NAME_FIELD, EXACT_RESPONSE_FIELD, EXACT_RESPONSE_FIELDS_FIELD, INCLUDE_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainEndpoint;

    private final String indexName;

    private final Boolean exactResponse;

    private final ExactResponseFields exactResponseFields;

    private final List<String> includeFields;

    private OpensearchConfiguration(BuilderImpl builder) {
        this.domainEndpoint = builder.domainEndpoint;
        this.indexName = builder.indexName;
        this.exactResponse = builder.exactResponse;
        this.exactResponseFields = builder.exactResponseFields;
        this.includeFields = builder.includeFields;
    }

    /**
     * <p>
     * The endpoint of the Amazon OpenSearch Service domain.
     * </p>
     * 
     * @return The endpoint of the Amazon OpenSearch Service domain.
     */
    public final String domainEndpoint() {
        return domainEndpoint;
    }

    /**
     * <p>
     * The name of the Amazon OpenSearch Service index.
     * </p>
     * 
     * @return The name of the Amazon OpenSearch Service index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you
     * specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response or to return an answer generated by the model using the
     *         fields you specify from the database.
     */
    public final Boolean exactResponse() {
        return exactResponse;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @return Contains the names of the fields used for an exact response to the user.
     */
    public final ExactResponseFields exactResponseFields() {
        return exactResponseFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeFields() {
        return includeFields != null && !(includeFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the
     * query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeFields} method.
     * </p>
     * 
     * @return Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the
     *         answer to the query.
     */
    public final List<String> includeFields() {
        return includeFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(exactResponse());
        hashCode = 31 * hashCode + Objects.hashCode(exactResponseFields());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeFields() ? includeFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpensearchConfiguration)) {
            return false;
        }
        OpensearchConfiguration other = (OpensearchConfiguration) obj;
        return Objects.equals(domainEndpoint(), other.domainEndpoint()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(exactResponse(), other.exactResponse())
                && Objects.equals(exactResponseFields(), other.exactResponseFields())
                && hasIncludeFields() == other.hasIncludeFields() && Objects.equals(includeFields(), other.includeFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpensearchConfiguration").add("DomainEndpoint", domainEndpoint()).add("IndexName", indexName())
                .add("ExactResponse", exactResponse()).add("ExactResponseFields", exactResponseFields())
                .add("IncludeFields", hasIncludeFields() ? includeFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainEndpoint":
            return Optional.ofNullable(clazz.cast(domainEndpoint()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "exactResponse":
            return Optional.ofNullable(clazz.cast(exactResponse()));
        case "exactResponseFields":
            return Optional.ofNullable(clazz.cast(exactResponseFields()));
        case "includeFields":
            return Optional.ofNullable(clazz.cast(includeFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainEndpoint", DOMAIN_ENDPOINT_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("exactResponse", EXACT_RESPONSE_FIELD);
        map.put("exactResponseFields", EXACT_RESPONSE_FIELDS_FIELD);
        map.put("includeFields", INCLUDE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpensearchConfiguration, T> g) {
        return obj -> g.apply((OpensearchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpensearchConfiguration> {
        /**
         * <p>
         * The endpoint of the Amazon OpenSearch Service domain.
         * </p>
         * 
         * @param domainEndpoint
         *        The endpoint of the Amazon OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpoint(String domainEndpoint);

        /**
         * <p>
         * The name of the Amazon OpenSearch Service index.
         * </p>
         * 
         * @param indexName
         *        The name of the Amazon OpenSearch Service index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Specifies whether to return an exact response or to return an answer generated by the model using the fields
         * you specify from the database.
         * </p>
         * 
         * @param exactResponse
         *        Specifies whether to return an exact response or to return an answer generated by the model using the
         *        fields you specify from the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactResponse(Boolean exactResponse);

        /**
         * <p>
         * Contains the names of the fields used for an exact response to the user.
         * </p>
         * 
         * @param exactResponseFields
         *        Contains the names of the fields used for an exact response to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactResponseFields(ExactResponseFields exactResponseFields);

        /**
         * <p>
         * Contains the names of the fields used for an exact response to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExactResponseFields.Builder} avoiding the
         * need to create one manually via {@link ExactResponseFields#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExactResponseFields.Builder#build()} is called immediately and
         * its result is passed to {@link #exactResponseFields(ExactResponseFields)}.
         * 
         * @param exactResponseFields
         *        a consumer that will call methods on {@link ExactResponseFields.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exactResponseFields(ExactResponseFields)
         */
        default Builder exactResponseFields(Consumer<ExactResponseFields.Builder> exactResponseFields) {
            return exactResponseFields(ExactResponseFields.builder().applyMutation(exactResponseFields).build());
        }

        /**
         * <p>
         * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to
         * the query.
         * </p>
         * 
         * @param includeFields
         *        Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the
         *        answer to the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFields(Collection<String> includeFields);

        /**
         * <p>
         * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to
         * the query.
         * </p>
         * 
         * @param includeFields
         *        Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the
         *        answer to the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFields(String... includeFields);
    }

    static final class BuilderImpl implements Builder {
        private String domainEndpoint;

        private String indexName;

        private Boolean exactResponse;

        private ExactResponseFields exactResponseFields;

        private List<String> includeFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpensearchConfiguration model) {
            domainEndpoint(model.domainEndpoint);
            indexName(model.indexName);
            exactResponse(model.exactResponse);
            exactResponseFields(model.exactResponseFields);
            includeFields(model.includeFields);
        }

        public final String getDomainEndpoint() {
            return domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Boolean getExactResponse() {
            return exactResponse;
        }

        public final void setExactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
        }

        @Override
        public final Builder exactResponse(Boolean exactResponse) {
            this.exactResponse = exactResponse;
            return this;
        }

        public final ExactResponseFields.Builder getExactResponseFields() {
            return exactResponseFields != null ? exactResponseFields.toBuilder() : null;
        }

        public final void setExactResponseFields(ExactResponseFields.BuilderImpl exactResponseFields) {
            this.exactResponseFields = exactResponseFields != null ? exactResponseFields.build() : null;
        }

        @Override
        public final Builder exactResponseFields(ExactResponseFields exactResponseFields) {
            this.exactResponseFields = exactResponseFields;
            return this;
        }

        public final Collection<String> getIncludeFields() {
            if (includeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return includeFields;
        }

        public final void setIncludeFields(Collection<String> includeFields) {
            this.includeFields = OSIncludeFieldsCopier.copy(includeFields);
        }

        @Override
        public final Builder includeFields(Collection<String> includeFields) {
            this.includeFields = OSIncludeFieldsCopier.copy(includeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeFields(String... includeFields) {
            includeFields(Arrays.asList(includeFields));
            return this;
        }

        @Override
        public OpensearchConfiguration build() {
            return new OpensearchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
