/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSlotsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListSlotsRequest.Builder, ListSlotsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListSlotsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListSlotsRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListSlotsRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(ListSlotsRequest::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("intentId").build()).build();

    private static final SdkField<SlotSortBy> SORT_BY_FIELD = SdkField.<SlotSortBy> builder(MarshallingType.SDK_POJO)
            .memberName("sortBy").getter(getter(ListSlotsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(SlotSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<SlotFilter>> FILTERS_FIELD = SdkField
            .<List<SlotFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListSlotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSlotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSlotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String intentId;

    private final SlotSortBy sortBy;

    private final List<SlotFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListSlotsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot that contains the slot.
     * </p>
     * 
     * @return The identifier of the bot that contains the slot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the slot.
     * </p>
     * 
     * @return The version of the bot that contains the slot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the slots to list. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale of the slots to list. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The unique identifier of the intent that contains the slot.
     * </p>
     * 
     * @return The unique identifier of the intent that contains the slot.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by
     * the slot name or last updated date in either ascending or descending order.
     * </p>
     * 
     * @return Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to
     *         sort by the slot name or last updated date in either ascending or descending order.
     */
    public final SlotSortBy sortBy() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the specification of a filter used to limit the slots in the response to only those that match the
     * filter specification. You can only specify one filter and only one string to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Provides the specification of a filter used to limit the slots in the response to only those that match
     *         the filter specification. You can only specify one filter and only one string to filter on.
     */
    public final List<SlotFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of slots to return in each page of results. If there are fewer results than the max page size,
     * only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of slots to return in each page of results. If there are fewer results than the max
     *         page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListSlots</code> operation contains more results than specified in the
     * <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     * <code>nextToken</code> parameter to return the next page of results.
     * </p>
     * 
     * @return If the response from the <code>ListSlots</code> operation contains more results than specified in the
     *         <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     *         <code>nextToken</code> parameter to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlotsRequest)) {
            return false;
        }
        ListSlotsRequest other = (ListSlotsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(intentId(), other.intentId())
                && Objects.equals(sortBy(), other.sortBy()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSlotsRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("IntentId", intentId()).add("SortBy", sortBy())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("intentId", INTENT_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSlotsRequest, T> g) {
        return obj -> g.apply((ListSlotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListSlotsRequest> {
        /**
         * <p>
         * The identifier of the bot that contains the slot.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the slot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the slots to list. The string must match one of the supported
         * locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the slots to list. The string must match one of the
         *        supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The unique identifier of the intent that contains the slot.
         * </p>
         * 
         * @param intentId
         *        The unique identifier of the intent that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort
         * by the slot name or last updated date in either ascending or descending order.
         * </p>
         * 
         * @param sortBy
         *        Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose
         *        to sort by the slot name or last updated date in either ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SlotSortBy sortBy);

        /**
         * <p>
         * Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort
         * by the slot name or last updated date in either ascending or descending order.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotSortBy.Builder} avoiding the need to
         * create one manually via {@link SlotSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotSortBy.Builder#build()} is called immediately and its result
         * is passed to {@link #sortBy(SlotSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SlotSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SlotSortBy)
         */
        default Builder sortBy(Consumer<SlotSortBy.Builder> sortBy) {
            return sortBy(SlotSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * Provides the specification of a filter used to limit the slots in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the slots in the response to only those that
         *        match the filter specification. You can only specify one filter and only one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SlotFilter> filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the slots in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the slots in the response to only those that
         *        match the filter specification. You can only specify one filter and only one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SlotFilter... filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the slots in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<SlotFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<SlotFilter>)
         */
        Builder filters(Consumer<SlotFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of slots to return in each page of results. If there are fewer results than the max page
         * size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of slots to return in each page of results. If there are fewer results than the max
         *        page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListSlots</code> operation contains more results than specified in the
         * <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         * <code>nextToken</code> parameter to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListSlots</code> operation contains more results than specified in the
         *        <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         *        <code>nextToken</code> parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String intentId;

        private SlotSortBy sortBy;

        private List<SlotFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlotsRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            intentId(model.intentId);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getIntentId() {
            return intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final SlotSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(SlotSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SlotSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<SlotFilter.Builder> getFilters() {
            List<SlotFilter.Builder> result = SlotFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SlotFilter.BuilderImpl> filters) {
            this.filters = SlotFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SlotFilter> filters) {
            this.filters = SlotFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SlotFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SlotFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SlotFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSlotsRequest build() {
            return new ListSlotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
