/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotVersionReplicasRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListBotVersionReplicasRequest.Builder, ListBotVersionReplicasRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotVersionReplicasRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicaRegion").getter(getter(ListBotVersionReplicasRequest::replicaRegion))
            .setter(setter(Builder::replicaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicaRegion").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBotVersionReplicasRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotVersionReplicasRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<BotVersionReplicaSortBy> SORT_BY_FIELD = SdkField
            .<BotVersionReplicaSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListBotVersionReplicasRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(BotVersionReplicaSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            REPLICA_REGION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String replicaRegion;

    private final Integer maxResults;

    private final String nextToken;

    private final BotVersionReplicaSortBy sortBy;

    private ListBotVersionReplicasRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.replicaRegion = builder.replicaRegion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The request for the unique ID in the list of replicated bots.
     * </p>
     * 
     * @return The request for the unique ID in the list of replicated bots.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The request for the region used in the list of replicated bots.
     * </p>
     * 
     * @return The request for the region used in the list of replicated bots.
     */
    public final String replicaRegion() {
        return replicaRegion;
    }

    /**
     * <p>
     * The maximum results given in the list of replicated bots.
     * </p>
     * 
     * @return The maximum results given in the list of replicated bots.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The next token given in the list of replicated bots.
     * </p>
     * 
     * @return The next token given in the list of replicated bots.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The requested sort category for the list of replicated bots.
     * </p>
     * 
     * @return The requested sort category for the list of replicated bots.
     */
    public final BotVersionReplicaSortBy sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionReplicasRequest)) {
            return false;
        }
        ListBotVersionReplicasRequest other = (ListBotVersionReplicasRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(replicaRegion(), other.replicaRegion())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotVersionReplicasRequest").add("BotId", botId()).add("ReplicaRegion", replicaRegion())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "replicaRegion":
            return Optional.ofNullable(clazz.cast(replicaRegion()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionReplicasRequest, T> g) {
        return obj -> g.apply((ListBotVersionReplicasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListBotVersionReplicasRequest> {
        /**
         * <p>
         * The request for the unique ID in the list of replicated bots.
         * </p>
         * 
         * @param botId
         *        The request for the unique ID in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The request for the region used in the list of replicated bots.
         * </p>
         * 
         * @param replicaRegion
         *        The request for the region used in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaRegion(String replicaRegion);

        /**
         * <p>
         * The maximum results given in the list of replicated bots.
         * </p>
         * 
         * @param maxResults
         *        The maximum results given in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The next token given in the list of replicated bots.
         * </p>
         * 
         * @param nextToken
         *        The next token given in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The requested sort category for the list of replicated bots.
         * </p>
         * 
         * @param sortBy
         *        The requested sort category for the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(BotVersionReplicaSortBy sortBy);

        /**
         * <p>
         * The requested sort category for the list of replicated bots.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotVersionReplicaSortBy.Builder} avoiding
         * the need to create one manually via {@link BotVersionReplicaSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BotVersionReplicaSortBy.Builder#build()} is called immediately
         * and its result is passed to {@link #sortBy(BotVersionReplicaSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link BotVersionReplicaSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(BotVersionReplicaSortBy)
         */
        default Builder sortBy(Consumer<BotVersionReplicaSortBy.Builder> sortBy) {
            return sortBy(BotVersionReplicaSortBy.builder().applyMutation(sortBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String replicaRegion;

        private Integer maxResults;

        private String nextToken;

        private BotVersionReplicaSortBy sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionReplicasRequest model) {
            super(model);
            botId(model.botId);
            replicaRegion(model.replicaRegion);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getReplicaRegion() {
            return replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final BotVersionReplicaSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(BotVersionReplicaSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(BotVersionReplicaSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBotVersionReplicasRequest build() {
            return new ListBotVersionReplicasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
