/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestExecutionArtifactsUrlResponse extends LexModelsV2Response implements
        ToCopyableBuilder<GetTestExecutionArtifactsUrlResponse.Builder, GetTestExecutionArtifactsUrlResponse> {
    private static final SdkField<String> TEST_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testExecutionId").getter(getter(GetTestExecutionArtifactsUrlResponse::testExecutionId))
            .setter(setter(Builder::testExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionId").build()).build();

    private static final SdkField<String> DOWNLOAD_ARTIFACTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadArtifactsUrl").getter(getter(GetTestExecutionArtifactsUrlResponse::downloadArtifactsUrl))
            .setter(setter(Builder::downloadArtifactsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadArtifactsUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_ID_FIELD,
            DOWNLOAD_ARTIFACTS_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testExecutionId;

    private final String downloadArtifactsUrl;

    private GetTestExecutionArtifactsUrlResponse(BuilderImpl builder) {
        super(builder);
        this.testExecutionId = builder.testExecutionId;
        this.downloadArtifactsUrl = builder.downloadArtifactsUrl;
    }

    /**
     * <p>
     * The unique identifier of the completed test execution.
     * </p>
     * 
     * @return The unique identifier of the completed test execution.
     */
    public final String testExecutionId() {
        return testExecutionId;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL to download completed test execution.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URL to download completed test execution.
     */
    public final String downloadArtifactsUrl() {
        return downloadArtifactsUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(downloadArtifactsUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestExecutionArtifactsUrlResponse)) {
            return false;
        }
        GetTestExecutionArtifactsUrlResponse other = (GetTestExecutionArtifactsUrlResponse) obj;
        return Objects.equals(testExecutionId(), other.testExecutionId())
                && Objects.equals(downloadArtifactsUrl(), other.downloadArtifactsUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestExecutionArtifactsUrlResponse").add("TestExecutionId", testExecutionId())
                .add("DownloadArtifactsUrl", downloadArtifactsUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionId":
            return Optional.ofNullable(clazz.cast(testExecutionId()));
        case "downloadArtifactsUrl":
            return Optional.ofNullable(clazz.cast(downloadArtifactsUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testExecutionId", TEST_EXECUTION_ID_FIELD);
        map.put("downloadArtifactsUrl", DOWNLOAD_ARTIFACTS_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestExecutionArtifactsUrlResponse, T> g) {
        return obj -> g.apply((GetTestExecutionArtifactsUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTestExecutionArtifactsUrlResponse> {
        /**
         * <p>
         * The unique identifier of the completed test execution.
         * </p>
         * 
         * @param testExecutionId
         *        The unique identifier of the completed test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionId(String testExecutionId);

        /**
         * <p>
         * The pre-signed Amazon S3 URL to download completed test execution.
         * </p>
         * 
         * @param downloadArtifactsUrl
         *        The pre-signed Amazon S3 URL to download completed test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadArtifactsUrl(String downloadArtifactsUrl);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String testExecutionId;

        private String downloadArtifactsUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestExecutionArtifactsUrlResponse model) {
            super(model);
            testExecutionId(model.testExecutionId);
            downloadArtifactsUrl(model.downloadArtifactsUrl);
        }

        public final String getTestExecutionId() {
            return testExecutionId;
        }

        public final void setTestExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
        }

        @Override
        public final Builder testExecutionId(String testExecutionId) {
            this.testExecutionId = testExecutionId;
            return this;
        }

        public final String getDownloadArtifactsUrl() {
            return downloadArtifactsUrl;
        }

        public final void setDownloadArtifactsUrl(String downloadArtifactsUrl) {
            this.downloadArtifactsUrl = downloadArtifactsUrl;
        }

        @Override
        public final Builder downloadArtifactsUrl(String downloadArtifactsUrl) {
            this.downloadArtifactsUrl = downloadArtifactsUrl;
            return this;
        }

        @Override
        public GetTestExecutionArtifactsUrlResponse build() {
            return new GetTestExecutionArtifactsUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
