/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotResponse.Builder, DescribeBotResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(DescribeBotResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeBotResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeBotResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(DescribeBotResponse::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(DescribeBotResponse::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(DescribeBotResponse::botStatusAsString)).setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeBotResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botType").getter(getter(DescribeBotResponse::botTypeAsString)).setter(setter(Builder::botType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botType").build()).build();

    private static final SdkField<List<BotMember>> BOT_MEMBERS_FIELD = SdkField
            .<List<BotMember>> builder(MarshallingType.LIST)
            .memberName("botMembers")
            .getter(getter(DescribeBotResponse::botMembers))
            .setter(setter(Builder::botMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeBotResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorLogSettings> ERROR_LOG_SETTINGS_FIELD = SdkField
            .<ErrorLogSettings> builder(MarshallingType.SDK_POJO).memberName("errorLogSettings")
            .getter(getter(DescribeBotResponse::errorLogSettings)).setter(setter(Builder::errorLogSettings))
            .constructor(ErrorLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorLogSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_STATUS_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, BOT_TYPE_FIELD, BOT_MEMBERS_FIELD, FAILURE_REASONS_FIELD,
            ERROR_LOG_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botName;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final String botStatus;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String botType;

    private final List<BotMember> botMembers;

    private final List<String> failureReasons;

    private final ErrorLogSettings errorLogSettings;

    private DescribeBotResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.botType = builder.botType;
        this.botMembers = builder.botMembers;
        this.failureReasons = builder.failureReasons;
        this.errorLogSettings = builder.errorLogSettings;
    }

    /**
     * <p>
     * The unique identifier of the bot.
     * </p>
     * 
     * @return The unique identifier of the bot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The description of the bot.
     * </p>
     * 
     * @return The description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Settings for managing data privacy of the bot and its conversations with users.
     * </p>
     * 
     * @return Settings for managing data privacy of the bot and its conversations with users.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
     * </p>
     * 
     * @return The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
     * conversations with users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
     *         conversations with users.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
     * conversations with users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
     *         conversations with users.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The type of the bot that was described.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot that was described.
     * @see BotType
     */
    public final BotType botType() {
        return BotType.fromValue(botType);
    }

    /**
     * <p>
     * The type of the bot that was described.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot that was described.
     * @see BotType
     */
    public final String botTypeAsString() {
        return botType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotMembers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBotMembers() {
        return botMembers != null && !(botMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of bots in the network that was described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotMembers} method.
     * </p>
     * 
     * @return The list of bots in the network that was described.
     */
    public final List<BotMember> botMembers() {
        return botMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot couldn't be
     * built.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot
     *         couldn't be built.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * Contains the configuration for error logging that specifies where and how bot errors are recorded, including
     * destinations like CloudWatch Logs.
     * </p>
     * 
     * @return Contains the configuration for error logging that specifies where and how bot errors are recorded,
     *         including destinations like CloudWatch Logs.
     */
    public final ErrorLogSettings errorLogSettings() {
        return errorLogSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotMembers() ? botMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorLogSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotResponse)) {
            return false;
        }
        DescribeBotResponse other = (DescribeBotResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(botTypeAsString(), other.botTypeAsString()) && hasBotMembers() == other.hasBotMembers()
                && Objects.equals(botMembers(), other.botMembers()) && hasFailureReasons() == other.hasFailureReasons()
                && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(errorLogSettings(), other.errorLogSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotResponse").add("BotId", botId()).add("BotName", botName())
                .add("Description", description()).add("RoleArn", roleArn()).add("DataPrivacy", dataPrivacy())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).add("BotStatus", botStatusAsString())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("BotType", botTypeAsString()).add("BotMembers", hasBotMembers() ? botMembers() : null)
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).add("ErrorLogSettings", errorLogSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "botType":
            return Optional.ofNullable(clazz.cast(botTypeAsString()));
        case "botMembers":
            return Optional.ofNullable(clazz.cast(botMembers()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "errorLogSettings":
            return Optional.ofNullable(clazz.cast(errorLogSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("dataPrivacy", DATA_PRIVACY_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("botStatus", BOT_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("botType", BOT_TYPE_FIELD);
        map.put("botMembers", BOT_MEMBERS_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("errorLogSettings", ERROR_LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotResponse, T> g) {
        return obj -> g.apply((DescribeBotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBotResponse> {
        /**
         * <p>
         * The unique identifier of the bot.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param botName
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The description of the bot.
         * </p>
         * 
         * @param description
         *        The description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Settings for managing data privacy of the bot and its conversations with users.
         * </p>
         * 
         * @param dataPrivacy
         *        Settings for managing data privacy of the bot and its conversations with users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * Settings for managing data privacy of the bot and its conversations with users.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to
         * create one manually via {@link DataPrivacy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
         * conversations with users.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code> the bot is ready to be used
         *        in conversations with users.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in
         * conversations with users.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code> the bot is ready to be used
         *        in conversations with users.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * A timestamp of the date and time that the bot was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the bot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the bot was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the bot was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The type of the bot that was described.
         * </p>
         * 
         * @param botType
         *        The type of the bot that was described.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(String botType);

        /**
         * <p>
         * The type of the bot that was described.
         * </p>
         * 
         * @param botType
         *        The type of the bot that was described.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(BotType botType);

        /**
         * <p>
         * The list of bots in the network that was described.
         * </p>
         * 
         * @param botMembers
         *        The list of bots in the network that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(Collection<BotMember> botMembers);

        /**
         * <p>
         * The list of bots in the network that was described.
         * </p>
         * 
         * @param botMembers
         *        The list of bots in the network that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(BotMember... botMembers);

        /**
         * <p>
         * The list of bots in the network that was described.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder#build()} is called immediately and
         * its result is passed to {@link #botMembers(List<BotMember>)}.
         * 
         * @param botMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botMembers(java.util.Collection<BotMember>)
         */
        Builder botMembers(Consumer<BotMember.Builder>... botMembers);

        /**
         * <p>
         * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot couldn't
         * be built.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot
         *        couldn't be built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot couldn't
         * be built.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot
         *        couldn't be built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * Contains the configuration for error logging that specifies where and how bot errors are recorded, including
         * destinations like CloudWatch Logs.
         * </p>
         * 
         * @param errorLogSettings
         *        Contains the configuration for error logging that specifies where and how bot errors are recorded,
         *        including destinations like CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorLogSettings(ErrorLogSettings errorLogSettings);

        /**
         * <p>
         * Contains the configuration for error logging that specifies where and how bot errors are recorded, including
         * destinations like CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorLogSettings.Builder} avoiding the
         * need to create one manually via {@link ErrorLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #errorLogSettings(ErrorLogSettings)}.
         * 
         * @param errorLogSettings
         *        a consumer that will call methods on {@link ErrorLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorLogSettings(ErrorLogSettings)
         */
        default Builder errorLogSettings(Consumer<ErrorLogSettings.Builder> errorLogSettings) {
            return errorLogSettings(ErrorLogSettings.builder().applyMutation(errorLogSettings).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private String botStatus;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String botType;

        private List<BotMember> botMembers = DefaultSdkAutoConstructList.getInstance();

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private ErrorLogSettings errorLogSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotResponse model) {
            super(model);
            botId(model.botId);
            botName(model.botName);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botStatus(model.botStatus);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            botType(model.botType);
            botMembers(model.botMembers);
            failureReasons(model.failureReasons);
            errorLogSettings(model.errorLogSettings);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getBotType() {
            return botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final List<BotMember.Builder> getBotMembers() {
            List<BotMember.Builder> result = BotMembersCopier.copyToBuilder(this.botMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotMembers(Collection<BotMember.BuilderImpl> botMembers) {
            this.botMembers = BotMembersCopier.copyFromBuilder(botMembers);
        }

        @Override
        public final Builder botMembers(Collection<BotMember> botMembers) {
            this.botMembers = BotMembersCopier.copy(botMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(BotMember... botMembers) {
            botMembers(Arrays.asList(botMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(Consumer<BotMember.Builder>... botMembers) {
            botMembers(Stream.of(botMembers).map(c -> BotMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final ErrorLogSettings.Builder getErrorLogSettings() {
            return errorLogSettings != null ? errorLogSettings.toBuilder() : null;
        }

        public final void setErrorLogSettings(ErrorLogSettings.BuilderImpl errorLogSettings) {
            this.errorLogSettings = errorLogSettings != null ? errorLogSettings.build() : null;
        }

        @Override
        public final Builder errorLogSettings(ErrorLogSettings errorLogSettings) {
            this.errorLogSettings = errorLogSettings;
            return this;
        }

        @Override
        public DescribeBotResponse build() {
            return new DescribeBotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
