/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the DTMF input specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DTMFSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<DTMFSpecification.Builder, DTMFSpecification> {
    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxLength").getter(getter(DTMFSpecification::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLength").build()).build();

    private static final SdkField<Integer> END_TIMEOUT_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeoutMs").getter(getter(DTMFSpecification::endTimeoutMs)).setter(setter(Builder::endTimeoutMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeoutMs").build()).build();

    private static final SdkField<String> DELETION_CHARACTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deletionCharacter").getter(getter(DTMFSpecification::deletionCharacter))
            .setter(setter(Builder::deletionCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionCharacter").build()).build();

    private static final SdkField<String> END_CHARACTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endCharacter").getter(getter(DTMFSpecification::endCharacter)).setter(setter(Builder::endCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endCharacter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_LENGTH_FIELD,
            END_TIMEOUT_MS_FIELD, DELETION_CHARACTER_FIELD, END_CHARACTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxLength;

    private final Integer endTimeoutMs;

    private final String deletionCharacter;

    private final String endCharacter;

    private DTMFSpecification(BuilderImpl builder) {
        this.maxLength = builder.maxLength;
        this.endTimeoutMs = builder.endTimeoutMs;
        this.deletionCharacter = builder.deletionCharacter;
        this.endCharacter = builder.endCharacter;
    }

    /**
     * <p>
     * The maximum number of DTMF digits allowed in an utterance.
     * </p>
     * 
     * @return The maximum number of DTMF digits allowed in an utterance.
     */
    public final Integer maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
     * </p>
     * 
     * @return How long the bot should wait after the last DTMF character input before assuming that the input has
     *         concluded.
     */
    public final Integer endTimeoutMs() {
        return endTimeoutMs;
    }

    /**
     * <p>
     * The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
     * </p>
     * 
     * @return The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
     */
    public final String deletionCharacter() {
        return deletionCharacter;
    }

    /**
     * <p>
     * The DTMF character that immediately ends input. If the user does not press this character, the input ends after
     * the end timeout.
     * </p>
     * 
     * @return The DTMF character that immediately ends input. If the user does not press this character, the input ends
     *         after the end timeout.
     */
    public final String endCharacter() {
        return endCharacter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeoutMs());
        hashCode = 31 * hashCode + Objects.hashCode(deletionCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(endCharacter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DTMFSpecification)) {
            return false;
        }
        DTMFSpecification other = (DTMFSpecification) obj;
        return Objects.equals(maxLength(), other.maxLength()) && Objects.equals(endTimeoutMs(), other.endTimeoutMs())
                && Objects.equals(deletionCharacter(), other.deletionCharacter())
                && Objects.equals(endCharacter(), other.endCharacter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DTMFSpecification").add("MaxLength", maxLength()).add("EndTimeoutMs", endTimeoutMs())
                .add("DeletionCharacter", deletionCharacter()).add("EndCharacter", endCharacter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "endTimeoutMs":
            return Optional.ofNullable(clazz.cast(endTimeoutMs()));
        case "deletionCharacter":
            return Optional.ofNullable(clazz.cast(deletionCharacter()));
        case "endCharacter":
            return Optional.ofNullable(clazz.cast(endCharacter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxLength", MAX_LENGTH_FIELD);
        map.put("endTimeoutMs", END_TIMEOUT_MS_FIELD);
        map.put("deletionCharacter", DELETION_CHARACTER_FIELD);
        map.put("endCharacter", END_CHARACTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DTMFSpecification, T> g) {
        return obj -> g.apply((DTMFSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DTMFSpecification> {
        /**
         * <p>
         * The maximum number of DTMF digits allowed in an utterance.
         * </p>
         * 
         * @param maxLength
         *        The maximum number of DTMF digits allowed in an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Integer maxLength);

        /**
         * <p>
         * How long the bot should wait after the last DTMF character input before assuming that the input has
         * concluded.
         * </p>
         * 
         * @param endTimeoutMs
         *        How long the bot should wait after the last DTMF character input before assuming that the input has
         *        concluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeoutMs(Integer endTimeoutMs);

        /**
         * <p>
         * The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
         * </p>
         * 
         * @param deletionCharacter
         *        The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionCharacter(String deletionCharacter);

        /**
         * <p>
         * The DTMF character that immediately ends input. If the user does not press this character, the input ends
         * after the end timeout.
         * </p>
         * 
         * @param endCharacter
         *        The DTMF character that immediately ends input. If the user does not press this character, the input
         *        ends after the end timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endCharacter(String endCharacter);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxLength;

        private Integer endTimeoutMs;

        private String deletionCharacter;

        private String endCharacter;

        private BuilderImpl() {
        }

        private BuilderImpl(DTMFSpecification model) {
            maxLength(model.maxLength);
            endTimeoutMs(model.endTimeoutMs);
            deletionCharacter(model.deletionCharacter);
            endCharacter(model.endCharacter);
        }

        public final Integer getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Integer getEndTimeoutMs() {
            return endTimeoutMs;
        }

        public final void setEndTimeoutMs(Integer endTimeoutMs) {
            this.endTimeoutMs = endTimeoutMs;
        }

        @Override
        public final Builder endTimeoutMs(Integer endTimeoutMs) {
            this.endTimeoutMs = endTimeoutMs;
            return this;
        }

        public final String getDeletionCharacter() {
            return deletionCharacter;
        }

        public final void setDeletionCharacter(String deletionCharacter) {
            this.deletionCharacter = deletionCharacter;
        }

        @Override
        public final Builder deletionCharacter(String deletionCharacter) {
            this.deletionCharacter = deletionCharacter;
            return this;
        }

        public final String getEndCharacter() {
            return endCharacter;
        }

        public final void setEndCharacter(String endCharacter) {
            this.endCharacter = endCharacter;
        }

        @Override
        public final Builder endCharacter(String endCharacter) {
            this.endCharacter = endCharacter;
            return this;
        }

        @Override
        public DTMFSpecification build() {
            return new DTMFSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
