/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unique entry identifier for the custom vocabulary items.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomVocabularyEntryId implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomVocabularyEntryId.Builder, CustomVocabularyEntryId> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(CustomVocabularyEntryId::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String itemId;

    private CustomVocabularyEntryId(BuilderImpl builder) {
        this.itemId = builder.itemId;
    }

    /**
     * <p>
     * The unique item identifier for the custom vocabulary items.
     * </p>
     * 
     * @return The unique item identifier for the custom vocabulary items.
     */
    public final String itemId() {
        return itemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomVocabularyEntryId)) {
            return false;
        }
        CustomVocabularyEntryId other = (CustomVocabularyEntryId) obj;
        return Objects.equals(itemId(), other.itemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomVocabularyEntryId").add("ItemId", itemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("itemId", ITEM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomVocabularyEntryId, T> g) {
        return obj -> g.apply((CustomVocabularyEntryId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomVocabularyEntryId> {
        /**
         * <p>
         * The unique item identifier for the custom vocabulary items.
         * </p>
         * 
         * @param itemId
         *        The unique item identifier for the custom vocabulary items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);
    }

    static final class BuilderImpl implements Builder {
        private String itemId;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomVocabularyEntryId model) {
            itemId(model.itemId);
        }

        public final String getItemId() {
            return itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @Override
        public CustomVocabularyEntryId build() {
            return new CustomVocabularyEntryId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
