/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourcePolicyStatementRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateResourcePolicyStatementRequest.Builder, CreateResourcePolicyStatementRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(CreateResourcePolicyStatementRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(CreateResourcePolicyStatementRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("effect")
            .getter(getter(CreateResourcePolicyStatementRequest::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()).build();

    private static final SdkField<List<Principal>> PRINCIPAL_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("principal")
            .getter(getter(CreateResourcePolicyStatementRequest::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(CreateResourcePolicyStatementRequest::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Map<String, String>>> CONDITION_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("condition")
            .getter(getter(CreateResourcePolicyStatementRequest::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRevisionId").getter(getter(CreateResourcePolicyStatementRequest::expectedRevisionId))
            .setter(setter(Builder::expectedRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedRevisionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            STATEMENT_ID_FIELD, EFFECT_FIELD, PRINCIPAL_FIELD, ACTION_FIELD, CONDITION_FIELD, EXPECTED_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String statementId;

    private final String effect;

    private final List<Principal> principal;

    private final List<String> action;

    private final Map<String, Map<String, String>> condition;

    private final String expectedRevisionId;

    private CreateResourcePolicyStatementRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.statementId = builder.statementId;
        this.effect = builder.effect;
        this.principal = builder.principal;
        this.action = builder.action;
        this.condition = builder.condition;
        this.expectedRevisionId = builder.expectedRevisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be
     * unique within the policy. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy
     * elements: Sid</a>.
     * </p>
     * 
     * @return The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name
     *         must be unique within the policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON
     *         policy elements: Sid</a>.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * Determines whether the statement allows or denies access to the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link Effect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return Determines whether the statement allows or denies access to the resource.
     * @see Effect
     */
    public final Effect effect() {
        return Effect.fromValue(effect);
    }

    /**
     * <p>
     * Determines whether the statement allows or denies access to the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link Effect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return Determines whether the statement allows or denies access to the resource.
     * @see Effect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principal property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied access
     * to a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon Web
     * Services JSON policy elements: Principal</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipal} method.
     * </p>
     * 
     * @return An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or
     *         denied access to a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon
     *         Web Services JSON policy elements: Principal</a>.
     */
    public final List<Principal> principal() {
        return principal;
    }

    /**
     * For responses, this returns true if the service returned a value for the Action property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the
     * specified ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions,
     * resources, and condition keys for Amazon Lex V2</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAction} method.
     * </p>
     * 
     * @return The Amazon Lex action that this policy either allows or denies. The action must apply to the resource
     *         type of the specified ARN. For more information, see <a
     *         href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions,
     *         resources, and condition keys for Amazon Lex V2</a>.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Condition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCondition() {
        return condition != null && !(condition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you
     * must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global
     * condition key.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON
     * policy elements: Condition </a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCondition} method.
     * </p>
     * 
     * @return Specifies a condition when the policy is in effect. If the principal of the policy is a service
     *         principal, you must provide two condition blocks, one with a SourceAccount global condition key and one
     *         with a SourceArn global condition key.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM
     *         JSON policy elements: Condition </a>.
     */
    public final Map<String, Map<String, String>> condition() {
        return condition;
    }

    /**
     * <p>
     * The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID,
     * Amazon Lex throws an exception.
     * </p>
     * <p>
     * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
     * </p>
     * 
     * @return The identifier of the revision of the policy to edit. If this revision ID doesn't match the current
     *         revision ID, Amazon Lex throws an exception.</p>
     *         <p>
     *         If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
     */
    public final String expectedRevisionId() {
        return expectedRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCondition() ? condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expectedRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourcePolicyStatementRequest)) {
            return false;
        }
        CreateResourcePolicyStatementRequest other = (CreateResourcePolicyStatementRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(statementId(), other.statementId())
                && Objects.equals(effectAsString(), other.effectAsString()) && hasPrincipal() == other.hasPrincipal()
                && Objects.equals(principal(), other.principal()) && hasAction() == other.hasAction()
                && Objects.equals(action(), other.action()) && hasCondition() == other.hasCondition()
                && Objects.equals(condition(), other.condition())
                && Objects.equals(expectedRevisionId(), other.expectedRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourcePolicyStatementRequest").add("ResourceArn", resourceArn())
                .add("StatementId", statementId()).add("Effect", effectAsString())
                .add("Principal", hasPrincipal() ? principal() : null).add("Action", hasAction() ? action() : null)
                .add("Condition", hasCondition() ? condition() : null).add("ExpectedRevisionId", expectedRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "expectedRevisionId":
            return Optional.ofNullable(clazz.cast(expectedRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        map.put("effect", EFFECT_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("expectedRevisionId", EXPECTED_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourcePolicyStatementRequest, T> g) {
        return obj -> g.apply((CreateResourcePolicyStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourcePolicyStatementRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must
         * be unique within the policy. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy
         * elements: Sid</a>.
         * </p>
         * 
         * @param statementId
         *        The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name
         *        must be unique within the policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON
         *        policy elements: Sid</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * Determines whether the statement allows or denies access to the resource.
         * </p>
         * 
         * @param effect
         *        Determines whether the statement allows or denies access to the resource.
         * @see Effect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Effect
         */
        Builder effect(String effect);

        /**
         * <p>
         * Determines whether the statement allows or denies access to the resource.
         * </p>
         * 
         * @param effect
         *        Determines whether the statement allows or denies access to the resource.
         * @see Effect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Effect
         */
        Builder effect(Effect effect);

        /**
         * <p>
         * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied
         * access to a resource. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon Web
         * Services JSON policy elements: Principal</a>.
         * </p>
         * 
         * @param principal
         *        An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or
         *        denied access to a resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html"
         *        >Amazon Web Services JSON policy elements: Principal</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Collection<Principal> principal);

        /**
         * <p>
         * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied
         * access to a resource. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon Web
         * Services JSON policy elements: Principal</a>.
         * </p>
         * 
         * @param principal
         *        An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or
         *        denied access to a resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html"
         *        >Amazon Web Services JSON policy elements: Principal</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Principal... principal);

        /**
         * <p>
         * An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied
         * access to a resource. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon Web
         * Services JSON policy elements: Principal</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.Principal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.Principal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.Principal.Builder#build()} is called immediately and
         * its result is passed to {@link #principal(List<Principal>)}.
         * 
         * @param principal
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.Principal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(java.util.Collection<Principal>)
         */
        Builder principal(Consumer<Principal.Builder>... principal);

        /**
         * <p>
         * The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of
         * the specified ARN. For more information, see <a
         * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions,
         * resources, and condition keys for Amazon Lex V2</a>.
         * </p>
         * 
         * @param action
         *        The Amazon Lex action that this policy either allows or denies. The action must apply to the resource
         *        type of the specified ARN. For more information, see <a
         *        href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html">
         *        Actions, resources, and condition keys for Amazon Lex V2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of
         * the specified ARN. For more information, see <a
         * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions,
         * resources, and condition keys for Amazon Lex V2</a>.
         * </p>
         * 
         * @param action
         *        The Amazon Lex action that this policy either allows or denies. The action must apply to the resource
         *        type of the specified ARN. For more information, see <a
         *        href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html">
         *        Actions, resources, and condition keys for Amazon Lex V2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * Specifies a condition when the policy is in effect. If the principal of the policy is a service principal,
         * you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn
         * global condition key.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON
         * policy elements: Condition </a>.
         * </p>
         * 
         * @param condition
         *        Specifies a condition when the policy is in effect. If the principal of the policy is a service
         *        principal, you must provide two condition blocks, one with a SourceAccount global condition key and
         *        one with a SourceArn global condition key.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM
         *        JSON policy elements: Condition </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Map<String, ? extends Map<String, String>> condition);

        /**
         * <p>
         * The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision
         * ID, Amazon Lex throws an exception.
         * </p>
         * <p>
         * If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
         * </p>
         * 
         * @param expectedRevisionId
         *        The identifier of the revision of the policy to edit. If this revision ID doesn't match the current
         *        revision ID, Amazon Lex throws an exception.</p>
         *        <p>
         *        If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRevisionId(String expectedRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private String statementId;

        private String effect;

        private List<Principal> principal = DefaultSdkAutoConstructList.getInstance();

        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Map<String, String>> condition = DefaultSdkAutoConstructMap.getInstance();

        private String expectedRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourcePolicyStatementRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            statementId(model.statementId);
            effect(model.effect);
            principal(model.principal);
            action(model.action);
            condition(model.condition);
            expectedRevisionId(model.expectedRevisionId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(Effect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final List<Principal.Builder> getPrincipal() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principal);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipal(Collection<Principal.BuilderImpl> principal) {
            this.principal = PrincipalListCopier.copyFromBuilder(principal);
        }

        @Override
        public final Builder principal(Collection<Principal> principal) {
            this.principal = PrincipalListCopier.copy(principal);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(Principal... principal) {
            principal(Arrays.asList(principal));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(Consumer<Principal.Builder>... principal) {
            principal(Stream.of(principal).map(c -> Principal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        public final void setAction(Collection<String> action) {
            this.action = OperationListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = OperationListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getCondition() {
            if (condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return condition;
        }

        public final void setCondition(Map<String, ? extends Map<String, String>> condition) {
            this.condition = ConditionMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, ? extends Map<String, String>> condition) {
            this.condition = ConditionMapCopier.copy(condition);
            return this;
        }

        public final String getExpectedRevisionId() {
            return expectedRevisionId;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourcePolicyStatementRequest build() {
            return new CreateResourcePolicyStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
