/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of actions that Amazon Lex should run if the condition is matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalBranch implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalBranch.Builder, ConditionalBranch> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConditionalBranch::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Condition> CONDITION_FIELD = SdkField.<Condition> builder(MarshallingType.SDK_POJO)
            .memberName("condition").getter(getter(ConditionalBranch::condition)).setter(setter(Builder::condition))
            .constructor(Condition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<DialogState> NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("nextStep").getter(getter(ConditionalBranch::nextStep)).setter(setter(Builder::nextStep))
            .constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextStep").build()).build();

    private static final SdkField<ResponseSpecification> RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("response")
            .getter(getter(ConditionalBranch::response)).setter(setter(Builder::response))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONDITION_FIELD,
            NEXT_STEP_FIELD, RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Condition condition;

    private final DialogState nextStep;

    private final ResponseSpecification response;

    private ConditionalBranch(BuilderImpl builder) {
        this.name = builder.name;
        this.condition = builder.condition;
        this.nextStep = builder.nextStep;
        this.response = builder.response;
    }

    /**
     * <p>
     * The name of the branch.
     * </p>
     * 
     * @return The name of the branch.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
     * </p>
     * 
     * @return Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
     */
    public final Condition condition() {
        return condition;
    }

    /**
     * <p>
     * The next step in the conversation.
     * </p>
     * 
     * @return The next step in the conversation.
     */
    public final DialogState nextStep() {
        return nextStep;
    }

    /**
     * Returns the value of the Response property for this object.
     * 
     * @return The value of the Response property for this object.
     */
    public final ResponseSpecification response() {
        return response;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(nextStep());
        hashCode = 31 * hashCode + Objects.hashCode(response());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalBranch)) {
            return false;
        }
        ConditionalBranch other = (ConditionalBranch) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(condition(), other.condition())
                && Objects.equals(nextStep(), other.nextStep()) && Objects.equals(response(), other.response());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalBranch").add("Name", name()).add("Condition", condition())
                .add("NextStep", nextStep()).add("Response", response()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "nextStep":
            return Optional.ofNullable(clazz.cast(nextStep()));
        case "response":
            return Optional.ofNullable(clazz.cast(response()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("nextStep", NEXT_STEP_FIELD);
        map.put("response", RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalBranch, T> g) {
        return obj -> g.apply((ConditionalBranch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalBranch> {
        /**
         * <p>
         * The name of the branch.
         * </p>
         * 
         * @param name
         *        The name of the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
         * </p>
         * 
         * @param condition
         *        Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * <p>
         * Contains the expression to evaluate. If the condition is true, the branch's actions are taken.
         * </p>
         * This is a convenience method that creates an instance of the {@link Condition.Builder} avoiding the need to
         * create one manually via {@link Condition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * 
         * @param nextStep
         *        The next step in the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStep(DialogState nextStep);

        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #nextStep(DialogState)}.
         * 
         * @param nextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextStep(DialogState)
         */
        default Builder nextStep(Consumer<DialogState.Builder> nextStep) {
            return nextStep(DialogState.builder().applyMutation(nextStep).build());
        }

        /**
         * Sets the value of the Response property for this object.
         *
         * @param response
         *        The new value for the Response property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(ResponseSpecification response);

        /**
         * Sets the value of the Response property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #response(ResponseSpecification)}.
         * 
         * @param response
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #response(ResponseSpecification)
         */
        default Builder response(Consumer<ResponseSpecification.Builder> response) {
            return response(ResponseSpecification.builder().applyMutation(response).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Condition condition;

        private DialogState nextStep;

        private ResponseSpecification response;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalBranch model) {
            name(model.name);
            condition(model.condition);
            nextStep(model.nextStep);
            response(model.response);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final DialogState.Builder getNextStep() {
            return nextStep != null ? nextStep.toBuilder() : null;
        }

        public final void setNextStep(DialogState.BuilderImpl nextStep) {
            this.nextStep = nextStep != null ? nextStep.build() : null;
        }

        @Override
        public final Builder nextStep(DialogState nextStep) {
            this.nextStep = nextStep;
            return this;
        }

        public final ResponseSpecification.Builder getResponse() {
            return response != null ? response.toBuilder() : null;
        }

        public final void setResponse(ResponseSpecification.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(ResponseSpecification response) {
            this.response = response;
            return this;
        }

        @Override
        public ConditionalBranch build() {
            return new ConditionalBranch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
