/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A statistical summary of the bot recommendation results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotRecommendationResultStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<BotRecommendationResultStatistics.Builder, BotRecommendationResultStatistics> {
    private static final SdkField<IntentStatistics> INTENTS_FIELD = SdkField.<IntentStatistics> builder(MarshallingType.SDK_POJO)
            .memberName("intents").getter(getter(BotRecommendationResultStatistics::intents)).setter(setter(Builder::intents))
            .constructor(IntentStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intents").build()).build();

    private static final SdkField<SlotTypeStatistics> SLOT_TYPES_FIELD = SdkField
            .<SlotTypeStatistics> builder(MarshallingType.SDK_POJO).memberName("slotTypes")
            .getter(getter(BotRecommendationResultStatistics::slotTypes)).setter(setter(Builder::slotTypes))
            .constructor(SlotTypeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENTS_FIELD,
            SLOT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IntentStatistics intents;

    private final SlotTypeStatistics slotTypes;

    private BotRecommendationResultStatistics(BuilderImpl builder) {
        this.intents = builder.intents;
        this.slotTypes = builder.slotTypes;
    }

    /**
     * <p>
     * Statistical information about about the intents associated with the bot recommendation results.
     * </p>
     * 
     * @return Statistical information about about the intents associated with the bot recommendation results.
     */
    public final IntentStatistics intents() {
        return intents;
    }

    /**
     * <p>
     * Statistical information about the slot types associated with the bot recommendation results.
     * </p>
     * 
     * @return Statistical information about the slot types associated with the bot recommendation results.
     */
    public final SlotTypeStatistics slotTypes() {
        return slotTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotRecommendationResultStatistics)) {
            return false;
        }
        BotRecommendationResultStatistics other = (BotRecommendationResultStatistics) obj;
        return Objects.equals(intents(), other.intents()) && Objects.equals(slotTypes(), other.slotTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotRecommendationResultStatistics").add("Intents", intents()).add("SlotTypes", slotTypes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intents":
            return Optional.ofNullable(clazz.cast(intents()));
        case "slotTypes":
            return Optional.ofNullable(clazz.cast(slotTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intents", INTENTS_FIELD);
        map.put("slotTypes", SLOT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotRecommendationResultStatistics, T> g) {
        return obj -> g.apply((BotRecommendationResultStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotRecommendationResultStatistics> {
        /**
         * <p>
         * Statistical information about about the intents associated with the bot recommendation results.
         * </p>
         * 
         * @param intents
         *        Statistical information about about the intents associated with the bot recommendation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(IntentStatistics intents);

        /**
         * <p>
         * Statistical information about about the intents associated with the bot recommendation results.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentStatistics.Builder} avoiding the
         * need to create one manually via {@link IntentStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #intents(IntentStatistics)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link IntentStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(IntentStatistics)
         */
        default Builder intents(Consumer<IntentStatistics.Builder> intents) {
            return intents(IntentStatistics.builder().applyMutation(intents).build());
        }

        /**
         * <p>
         * Statistical information about the slot types associated with the bot recommendation results.
         * </p>
         * 
         * @param slotTypes
         *        Statistical information about the slot types associated with the bot recommendation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(SlotTypeStatistics slotTypes);

        /**
         * <p>
         * Statistical information about the slot types associated with the bot recommendation results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotTypeStatistics.Builder} avoiding the
         * need to create one manually via {@link SlotTypeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotTypeStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #slotTypes(SlotTypeStatistics)}.
         * 
         * @param slotTypes
         *        a consumer that will call methods on {@link SlotTypeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypes(SlotTypeStatistics)
         */
        default Builder slotTypes(Consumer<SlotTypeStatistics.Builder> slotTypes) {
            return slotTypes(SlotTypeStatistics.builder().applyMutation(slotTypes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IntentStatistics intents;

        private SlotTypeStatistics slotTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(BotRecommendationResultStatistics model) {
            intents(model.intents);
            slotTypes(model.slotTypes);
        }

        public final IntentStatistics.Builder getIntents() {
            return intents != null ? intents.toBuilder() : null;
        }

        public final void setIntents(IntentStatistics.BuilderImpl intents) {
            this.intents = intents != null ? intents.build() : null;
        }

        @Override
        public final Builder intents(IntentStatistics intents) {
            this.intents = intents;
            return this;
        }

        public final SlotTypeStatistics.Builder getSlotTypes() {
            return slotTypes != null ? slotTypes.toBuilder() : null;
        }

        public final void setSlotTypes(SlotTypeStatistics.BuilderImpl slotTypes) {
            this.slotTypes = slotTypes != null ? slotTypes.build() : null;
        }

        @Override
        public final Builder slotTypes(SlotTypeStatistics slotTypes) {
            this.slotTypes = slotTypes;
            return this;
        }

        @Override
        public BotRecommendationResultStatistics build() {
            return new BotRecommendationResultStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
