/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an event that occurred affecting the bot locale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotLocaleHistoryEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<BotLocaleHistoryEvent.Builder, BotLocaleHistoryEvent> {
    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(BotLocaleHistoryEvent::event)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventDate").getter(getter(BotLocaleHistoryEvent::eventDate)).setter(setter(Builder::eventDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EVENT_FIELD, EVENT_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String event;

    private final Instant eventDate;

    private BotLocaleHistoryEvent(BuilderImpl builder) {
        this.event = builder.event;
        this.eventDate = builder.eventDate;
    }

    /**
     * <p>
     * A description of the event that occurred.
     * </p>
     * 
     * @return A description of the event that occurred.
     */
    public final String event() {
        return event;
    }

    /**
     * <p>
     * A timestamp of the date and time that the event occurred.
     * </p>
     * 
     * @return A timestamp of the date and time that the event occurred.
     */
    public final Instant eventDate() {
        return eventDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(eventDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotLocaleHistoryEvent)) {
            return false;
        }
        BotLocaleHistoryEvent other = (BotLocaleHistoryEvent) obj;
        return Objects.equals(event(), other.event()) && Objects.equals(eventDate(), other.eventDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotLocaleHistoryEvent").add("Event", event()).add("EventDate", eventDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        case "eventDate":
            return Optional.ofNullable(clazz.cast(eventDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("event", EVENT_FIELD);
        map.put("eventDate", EVENT_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotLocaleHistoryEvent, T> g) {
        return obj -> g.apply((BotLocaleHistoryEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotLocaleHistoryEvent> {
        /**
         * <p>
         * A description of the event that occurred.
         * </p>
         * 
         * @param event
         *        A description of the event that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(String event);

        /**
         * <p>
         * A timestamp of the date and time that the event occurred.
         * </p>
         * 
         * @param eventDate
         *        A timestamp of the date and time that the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDate(Instant eventDate);
    }

    static final class BuilderImpl implements Builder {
        private String event;

        private Instant eventDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BotLocaleHistoryEvent model) {
            event(model.event);
            eventDate(model.eventDate);
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final Instant getEventDate() {
            return eventDate;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        @Override
        public BotLocaleHistoryEvent build() {
            return new BotLocaleHistoryEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
