/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies settings that are unique to a locale. For example, you can use different Lambda function depending on the
 * bot's locale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotAliasLocaleSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<BotAliasLocaleSettings.Builder, BotAliasLocaleSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(BotAliasLocaleSettings::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<CodeHookSpecification> CODE_HOOK_SPECIFICATION_FIELD = SdkField
            .<CodeHookSpecification> builder(MarshallingType.SDK_POJO).memberName("codeHookSpecification")
            .getter(getter(BotAliasLocaleSettings::codeHookSpecification)).setter(setter(Builder::codeHookSpecification))
            .constructor(CodeHookSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHookSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            CODE_HOOK_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final CodeHookSpecification codeHookSpecification;

    private BotAliasLocaleSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.codeHookSpecification = builder.codeHookSpecification;
    }

    /**
     * <p>
     * Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale isn't
     * available for use.
     * </p>
     * 
     * @return Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale
     *         isn't available for use.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies the Lambda function that should be used in the locale.
     * </p>
     * 
     * @return Specifies the Lambda function that should be used in the locale.
     */
    public final CodeHookSpecification codeHookSpecification() {
        return codeHookSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(codeHookSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasLocaleSettings)) {
            return false;
        }
        BotAliasLocaleSettings other = (BotAliasLocaleSettings) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(codeHookSpecification(), other.codeHookSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotAliasLocaleSettings").add("Enabled", enabled())
                .add("CodeHookSpecification", codeHookSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "codeHookSpecification":
            return Optional.ofNullable(clazz.cast(codeHookSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("codeHookSpecification", CODE_HOOK_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotAliasLocaleSettings, T> g) {
        return obj -> g.apply((BotAliasLocaleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotAliasLocaleSettings> {
        /**
         * <p>
         * Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale isn't
         * available for use.
         * </p>
         * 
         * @param enabled
         *        Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale
         *        isn't available for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies the Lambda function that should be used in the locale.
         * </p>
         * 
         * @param codeHookSpecification
         *        Specifies the Lambda function that should be used in the locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHookSpecification(CodeHookSpecification codeHookSpecification);

        /**
         * <p>
         * Specifies the Lambda function that should be used in the locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeHookSpecification.Builder} avoiding
         * the need to create one manually via {@link CodeHookSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeHookSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #codeHookSpecification(CodeHookSpecification)}.
         * 
         * @param codeHookSpecification
         *        a consumer that will call methods on {@link CodeHookSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHookSpecification(CodeHookSpecification)
         */
        default Builder codeHookSpecification(Consumer<CodeHookSpecification.Builder> codeHookSpecification) {
            return codeHookSpecification(CodeHookSpecification.builder().applyMutation(codeHookSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private CodeHookSpecification codeHookSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasLocaleSettings model) {
            enabled(model.enabled);
            codeHookSpecification(model.codeHookSpecification);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final CodeHookSpecification.Builder getCodeHookSpecification() {
            return codeHookSpecification != null ? codeHookSpecification.toBuilder() : null;
        }

        public final void setCodeHookSpecification(CodeHookSpecification.BuilderImpl codeHookSpecification) {
            this.codeHookSpecification = codeHookSpecification != null ? codeHookSpecification.build() : null;
        }

        @Override
        public final Builder codeHookSpecification(CodeHookSpecification codeHookSpecification) {
            this.codeHookSpecification = codeHookSpecification;
            return this;
        }

        @Override
        public BotAliasLocaleSettings build() {
            return new BotAliasLocaleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
