/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateCustomVocabularyItemRequest extends LexModelsV2Request implements
        ToCopyableBuilder<BatchCreateCustomVocabularyItemRequest.Builder, BatchCreateCustomVocabularyItemRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(BatchCreateCustomVocabularyItemRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BatchCreateCustomVocabularyItemRequest::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(BatchCreateCustomVocabularyItemRequest::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<List<NewCustomVocabularyItem>> CUSTOM_VOCABULARY_ITEM_LIST_FIELD = SdkField
            .<List<NewCustomVocabularyItem>> builder(MarshallingType.LIST)
            .memberName("customVocabularyItemList")
            .getter(getter(BatchCreateCustomVocabularyItemRequest::customVocabularyItemList))
            .setter(setter(Builder::customVocabularyItemList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customVocabularyItemList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NewCustomVocabularyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(NewCustomVocabularyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, CUSTOM_VOCABULARY_ITEM_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<NewCustomVocabularyItem> customVocabularyItemList;

    private BatchCreateCustomVocabularyItemRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.customVocabularyItemList = builder.customVocabularyItemList;
    }

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the bot associated with this custom vocabulary.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with this custom vocabulary.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @return The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *         of the supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomVocabularyItemList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomVocabularyItemList() {
        return customVocabularyItemList != null && !(customVocabularyItemList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a displayAs
     * and/or a weight.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomVocabularyItemList} method.
     * </p>
     * 
     * @return A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
     *         displayAs and/or a weight.
     */
    public final List<NewCustomVocabularyItem> customVocabularyItemList() {
        return customVocabularyItemList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomVocabularyItemList() ? customVocabularyItemList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateCustomVocabularyItemRequest)) {
            return false;
        }
        BatchCreateCustomVocabularyItemRequest other = (BatchCreateCustomVocabularyItemRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && hasCustomVocabularyItemList() == other.hasCustomVocabularyItemList()
                && Objects.equals(customVocabularyItemList(), other.customVocabularyItemList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateCustomVocabularyItemRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId())
                .add("CustomVocabularyItemList", hasCustomVocabularyItemList() ? customVocabularyItemList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "customVocabularyItemList":
            return Optional.ofNullable(clazz.cast(customVocabularyItemList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("customVocabularyItemList", CUSTOM_VOCABULARY_ITEM_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateCustomVocabularyItemRequest, T> g) {
        return obj -> g.apply((BatchCreateCustomVocabularyItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateCustomVocabularyItemRequest> {
        /**
         * <p>
         * The identifier of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the version of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the version of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where this custom vocabulary is used. The string must match one of
         * the supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where this custom vocabulary is used. The string must match
         *        one of the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
         * displayAs and/or a weight.
         * </p>
         * 
         * @param customVocabularyItemList
         *        A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
         *        displayAs and/or a weight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyItemList(Collection<NewCustomVocabularyItem> customVocabularyItemList);

        /**
         * <p>
         * A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
         * displayAs and/or a weight.
         * </p>
         * 
         * @param customVocabularyItemList
         *        A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
         *        displayAs and/or a weight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyItemList(NewCustomVocabularyItem... customVocabularyItemList);

        /**
         * <p>
         * A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a
         * displayAs and/or a weight.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.NewCustomVocabularyItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.NewCustomVocabularyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.NewCustomVocabularyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #customVocabularyItemList(List<NewCustomVocabularyItem>)}.
         * 
         * @param customVocabularyItemList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.NewCustomVocabularyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customVocabularyItemList(java.util.Collection<NewCustomVocabularyItem>)
         */
        Builder customVocabularyItemList(Consumer<NewCustomVocabularyItem.Builder>... customVocabularyItemList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<NewCustomVocabularyItem> customVocabularyItemList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateCustomVocabularyItemRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            customVocabularyItemList(model.customVocabularyItemList);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<NewCustomVocabularyItem.Builder> getCustomVocabularyItemList() {
            List<NewCustomVocabularyItem.Builder> result = CreateCustomVocabularyItemsListCopier
                    .copyToBuilder(this.customVocabularyItemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomVocabularyItemList(Collection<NewCustomVocabularyItem.BuilderImpl> customVocabularyItemList) {
            this.customVocabularyItemList = CreateCustomVocabularyItemsListCopier.copyFromBuilder(customVocabularyItemList);
        }

        @Override
        public final Builder customVocabularyItemList(Collection<NewCustomVocabularyItem> customVocabularyItemList) {
            this.customVocabularyItemList = CreateCustomVocabularyItemsListCopier.copy(customVocabularyItemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItemList(NewCustomVocabularyItem... customVocabularyItemList) {
            customVocabularyItemList(Arrays.asList(customVocabularyItemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItemList(Consumer<NewCustomVocabularyItem.Builder>... customVocabularyItemList) {
            customVocabularyItemList(Stream.of(customVocabularyItemList)
                    .map(c -> NewCustomVocabularyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateCustomVocabularyItemRequest build() {
            return new BatchCreateCustomVocabularyItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
