/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AssociatedTranscriptFiltersCopier {
    static List<AssociatedTranscriptFilter> copy(Collection<? extends AssociatedTranscriptFilter> associatedTranscriptFiltersParam) {
        List<AssociatedTranscriptFilter> list;
        if (associatedTranscriptFiltersParam == null || associatedTranscriptFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssociatedTranscriptFilter> modifiableList = new ArrayList<>(associatedTranscriptFiltersParam.size());
            associatedTranscriptFiltersParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssociatedTranscriptFilter> copyFromBuilder(
            Collection<? extends AssociatedTranscriptFilter.Builder> associatedTranscriptFiltersParam) {
        List<AssociatedTranscriptFilter> list;
        if (associatedTranscriptFiltersParam == null || associatedTranscriptFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssociatedTranscriptFilter> modifiableList = new ArrayList<>(associatedTranscriptFiltersParam.size());
            associatedTranscriptFiltersParam.forEach(entry -> {
                AssociatedTranscriptFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AssociatedTranscriptFilter.Builder> copyToBuilder(
            Collection<? extends AssociatedTranscriptFilter> associatedTranscriptFiltersParam) {
        List<AssociatedTranscriptFilter.Builder> list;
        if (associatedTranscriptFiltersParam == null || associatedTranscriptFiltersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AssociatedTranscriptFilter.Builder> modifiableList = new ArrayList<>(associatedTranscriptFiltersParam.size());
            associatedTranscriptFiltersParam.forEach(entry -> {
                AssociatedTranscriptFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
