/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object containing information that associates the recommended intent/slot type with a conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedTranscript implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedTranscript.Builder, AssociatedTranscript> {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transcript").getter(getter(AssociatedTranscript::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transcript;

    private AssociatedTranscript(BuilderImpl builder) {
        this.transcript = builder.transcript;
    }

    /**
     * <p>
     * The content of the transcript that meets the search filter criteria. For the JSON format of the transcript, see
     * <a href="https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html">Output transcript format</a>.
     * </p>
     * 
     * @return The content of the transcript that meets the search filter criteria. For the JSON format of the
     *         transcript, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html">Output
     *         transcript format</a>.
     */
    public final String transcript() {
        return transcript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedTranscript)) {
            return false;
        }
        AssociatedTranscript other = (AssociatedTranscript) obj;
        return Objects.equals(transcript(), other.transcript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedTranscript").add("Transcript", transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transcript", TRANSCRIPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedTranscript, T> g) {
        return obj -> g.apply((AssociatedTranscript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedTranscript> {
        /**
         * <p>
         * The content of the transcript that meets the search filter criteria. For the JSON format of the transcript,
         * see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html">Output transcript
         * format</a>.
         * </p>
         * 
         * @param transcript
         *        The content of the transcript that meets the search filter criteria. For the JSON format of the
         *        transcript, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html">Output transcript
         *        format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);
    }

    static final class BuilderImpl implements Builder {
        private String transcript;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedTranscript model) {
            transcript(model.transcript);
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        @Override
        public AssociatedTranscript build() {
            return new AssociatedTranscript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
