/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the results for the intent metric you requested.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsIntentMetricResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsIntentMetricResult.Builder, AnalyticsIntentMetricResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalyticsIntentMetricResult::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statistic").getter(getter(AnalyticsIntentMetricResult::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(AnalyticsIntentMetricResult::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATISTIC_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String statistic;

    private final Double value;

    private AnalyticsIntentMetricResult(BuilderImpl builder) {
        this.name = builder.name;
        this.statistic = builder.statistic;
        this.value = builder.value;
    }

    /**
     * <p>
     * The metric that you requested. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for more
     * details about these metrics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Count</code> – The number of times the intent was invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Success</code> – The number of times the intent succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failure</code> – The number of times the intent failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Switched</code> – The number of times there was a switch to a different intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dropped</code> – The number of times the user dropped the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsIntentMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The metric that you requested. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for
     *         more details about these metrics.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Count</code> – The number of times the intent was invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Success</code> – The number of times the intent succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failure</code> – The number of times the intent failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Switched</code> – The number of times there was a switch to a different intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dropped</code> – The number of times the user dropped the intent.
     *         </p>
     *         </li>
     * @see AnalyticsIntentMetricName
     */
    public final AnalyticsIntentMetricName name() {
        return AnalyticsIntentMetricName.fromValue(name);
    }

    /**
     * <p>
     * The metric that you requested. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for more
     * details about these metrics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Count</code> – The number of times the intent was invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Success</code> – The number of times the intent succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failure</code> – The number of times the intent failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Switched</code> – The number of times there was a switch to a different intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dropped</code> – The number of times the user dropped the intent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsIntentMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The metric that you requested. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for
     *         more details about these metrics.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Count</code> – The number of times the intent was invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Success</code> – The number of times the intent succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failure</code> – The number of times the intent failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Switched</code> – The number of times there was a switch to a different intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dropped</code> – The number of times the user dropped the intent.
     *         </p>
     *         </li>
     * @see AnalyticsIntentMetricName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The statistic that you requested to calculate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Sum</code> – The total count for the category you provide in <code>name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> – The total count divided by the number of intents in the category you provide in
     * <code>name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Max</code> – The highest count in the category you provide in <code>name</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link AnalyticsMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic that you requested to calculate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Sum</code> – The total count for the category you provide in <code>name</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> – The total count divided by the number of intents in the category you provide in
     *         <code>name</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Max</code> – The highest count in the category you provide in <code>name</code>.
     *         </p>
     *         </li>
     * @see AnalyticsMetricStatistic
     */
    public final AnalyticsMetricStatistic statistic() {
        return AnalyticsMetricStatistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic that you requested to calculate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Sum</code> – The total count for the category you provide in <code>name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Average</code> – The total count divided by the number of intents in the category you provide in
     * <code>name</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Max</code> – The highest count in the category you provide in <code>name</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link AnalyticsMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic that you requested to calculate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Sum</code> – The total count for the category you provide in <code>name</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Average</code> – The total count divided by the number of intents in the category you provide in
     *         <code>name</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Max</code> – The highest count in the category you provide in <code>name</code>.
     *         </p>
     *         </li>
     * @see AnalyticsMetricStatistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The value of the summary statistic for the metric that you requested.
     * </p>
     * 
     * @return The value of the summary statistic for the metric that you requested.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentMetricResult)) {
            return false;
        }
        AnalyticsIntentMetricResult other = (AnalyticsIntentMetricResult) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsIntentMetricResult").add("Name", nameAsString()).add("Statistic", statisticAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("statistic", STATISTIC_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentMetricResult, T> g) {
        return obj -> g.apply((AnalyticsIntentMetricResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsIntentMetricResult> {
        /**
         * <p>
         * The metric that you requested. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for
         * more details about these metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Count</code> – The number of times the intent was invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Success</code> – The number of times the intent succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failure</code> – The number of times the intent failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Switched</code> – The number of times there was a switch to a different intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dropped</code> – The number of times the user dropped the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The metric that you requested. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a>
         *        for more details about these metrics.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Count</code> – The number of times the intent was invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Success</code> – The number of times the intent succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failure</code> – The number of times the intent failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Switched</code> – The number of times there was a switch to a different intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dropped</code> – The number of times the user dropped the intent.
         *        </p>
         *        </li>
         * @see AnalyticsIntentMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsIntentMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The metric that you requested. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for
         * more details about these metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Count</code> – The number of times the intent was invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Success</code> – The number of times the intent succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failure</code> – The number of times the intent failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Switched</code> – The number of times there was a switch to a different intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dropped</code> – The number of times the user dropped the intent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The metric that you requested. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a>
         *        for more details about these metrics.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Count</code> – The number of times the intent was invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Success</code> – The number of times the intent succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failure</code> – The number of times the intent failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Switched</code> – The number of times there was a switch to a different intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dropped</code> – The number of times the user dropped the intent.
         *        </p>
         *        </li>
         * @see AnalyticsIntentMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsIntentMetricName
         */
        Builder name(AnalyticsIntentMetricName name);

        /**
         * <p>
         * The statistic that you requested to calculate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Sum</code> – The total count for the category you provide in <code>name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> – The total count divided by the number of intents in the category you provide in
         * <code>name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Max</code> – The highest count in the category you provide in <code>name</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistic
         *        The statistic that you requested to calculate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Sum</code> – The total count for the category you provide in <code>name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> – The total count divided by the number of intents in the category you provide in
         *        <code>name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Max</code> – The highest count in the category you provide in <code>name</code>.
         *        </p>
         *        </li>
         * @see AnalyticsMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsMetricStatistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic that you requested to calculate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Sum</code> – The total count for the category you provide in <code>name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Average</code> – The total count divided by the number of intents in the category you provide in
         * <code>name</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Max</code> – The highest count in the category you provide in <code>name</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistic
         *        The statistic that you requested to calculate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Sum</code> – The total count for the category you provide in <code>name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Average</code> – The total count divided by the number of intents in the category you provide in
         *        <code>name</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Max</code> – The highest count in the category you provide in <code>name</code>.
         *        </p>
         *        </li>
         * @see AnalyticsMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsMetricStatistic
         */
        Builder statistic(AnalyticsMetricStatistic statistic);

        /**
         * <p>
         * The value of the summary statistic for the metric that you requested.
         * </p>
         * 
         * @param value
         *        The value of the summary statistic for the metric that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String statistic;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentMetricResult model) {
            name(model.name);
            statistic(model.statistic);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsIntentMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(AnalyticsMetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public AnalyticsIntentMetricResult build() {
            return new AnalyticsIntentMetricResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
