/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAssociatedTranscriptsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, SearchAssociatedTranscriptsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::botId)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::botVersion)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::localeId)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botRecommendationId").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::botRecommendationId)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::botRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botRecommendationId").build()}).build();
    private static final SdkField<String> SEARCH_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchOrder").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::searchOrderAsString)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::searchOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchOrder").build()}).build();
    private static final SdkField<List<AssociatedTranscriptFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::filters)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedTranscriptFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::maxResults)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<Integer> NEXT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nextIndex").getter(SearchAssociatedTranscriptsRequest.getter(SearchAssociatedTranscriptsRequest::nextIndex)).setter(SearchAssociatedTranscriptsRequest.setter(Builder::nextIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_ID_FIELD, SEARCH_ORDER_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchAssociatedTranscriptsRequest.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String botRecommendationId;
    private final String searchOrder;
    private final List<AssociatedTranscriptFilter> filters;
    private final Integer maxResults;
    private final Integer nextIndex;

    private SearchAssociatedTranscriptsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationId = builder.botRecommendationId;
        this.searchOrder = builder.searchOrder;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextIndex = builder.nextIndex;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String botRecommendationId() {
        return this.botRecommendationId;
    }

    public final SearchOrder searchOrder() {
        return SearchOrder.fromValue(this.searchOrder);
    }

    public final String searchOrderAsString() {
        return this.searchOrder;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AssociatedTranscriptFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Integer nextIndex() {
        return this.nextIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAssociatedTranscriptsRequest)) {
            return false;
        }
        SearchAssociatedTranscriptsRequest other = (SearchAssociatedTranscriptsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.botRecommendationId(), other.botRecommendationId()) && Objects.equals(this.searchOrderAsString(), other.searchOrderAsString()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextIndex(), other.nextIndex());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAssociatedTranscriptsRequest").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("BotRecommendationId", (Object)this.botRecommendationId()).add("SearchOrder", (Object)this.searchOrderAsString()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextIndex", (Object)this.nextIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "botRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationId()));
            }
            case "searchOrder": {
                return Optional.ofNullable(clazz.cast(this.searchOrderAsString()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextIndex": {
                return Optional.ofNullable(clazz.cast(this.nextIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("botRecommendationId", BOT_RECOMMENDATION_ID_FIELD);
        map.put("searchOrder", SEARCH_ORDER_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextIndex", NEXT_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAssociatedTranscriptsRequest, T> g) {
        return obj -> g.apply((SearchAssociatedTranscriptsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String botRecommendationId;
        private String searchOrder;
        private List<AssociatedTranscriptFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private Integer nextIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAssociatedTranscriptsRequest model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.botRecommendationId(model.botRecommendationId);
            this.searchOrder(model.searchOrder);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextIndex(model.nextIndex);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationId() {
            return this.botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final String getSearchOrder() {
            return this.searchOrder;
        }

        public final void setSearchOrder(String searchOrder) {
            this.searchOrder = searchOrder;
        }

        @Override
        public final Builder searchOrder(String searchOrder) {
            this.searchOrder = searchOrder;
            return this;
        }

        @Override
        public final Builder searchOrder(SearchOrder searchOrder) {
            this.searchOrder(searchOrder == null ? null : searchOrder.toString());
            return this;
        }

        public final List<AssociatedTranscriptFilter.Builder> getFilters() {
            List<AssociatedTranscriptFilter.Builder> result = AssociatedTranscriptFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AssociatedTranscriptFilter.BuilderImpl> filters) {
            this.filters = AssociatedTranscriptFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AssociatedTranscriptFilter> filters) {
            this.filters = AssociatedTranscriptFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AssociatedTranscriptFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AssociatedTranscriptFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AssociatedTranscriptFilter)((AssociatedTranscriptFilter.Builder)AssociatedTranscriptFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
        }

        @Override
        public final Builder nextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAssociatedTranscriptsRequest build() {
            return new SearchAssociatedTranscriptsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAssociatedTranscriptsRequest> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder botRecommendationId(String var1);

        public Builder searchOrder(String var1);

        public Builder searchOrder(SearchOrder var1);

        public Builder filters(Collection<AssociatedTranscriptFilter> var1);

        public Builder filters(AssociatedTranscriptFilter ... var1);

        public Builder filters(Consumer<AssociatedTranscriptFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextIndex(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

