/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.VoiceEngine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceSettings> {
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("voiceId").getter(VoiceSettings.getter(VoiceSettings::voiceId)).setter(VoiceSettings.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceId").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(VoiceSettings.getter(VoiceSettings::engineAsString)).setter(VoiceSettings.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_ID_FIELD, ENGINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceId", VOICE_ID_FIELD);
            this.put("engine", ENGINE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String voiceId;
    private final String engine;

    private VoiceSettings(BuilderImpl builder) {
        this.voiceId = builder.voiceId;
        this.engine = builder.engine;
    }

    public final String voiceId() {
        return this.voiceId;
    }

    public final VoiceEngine engine() {
        return VoiceEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceSettings)) {
            return false;
        }
        VoiceSettings other = (VoiceSettings)obj;
        return Objects.equals(this.voiceId(), other.voiceId()) && Objects.equals(this.engineAsString(), other.engineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VoiceSettings").add("VoiceId", (Object)this.voiceId()).add("Engine", (Object)this.engineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "voiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceId()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VoiceSettings, T> g) {
        return obj -> g.apply((VoiceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String voiceId;
        private String engine;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceSettings model) {
            this.voiceId(model.voiceId);
            this.engine(model.engine);
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(VoiceEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public VoiceSettings build() {
            return new VoiceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceSettings> {
        public Builder voiceId(String var1);

        public Builder engine(String var1);

        public Builder engine(VoiceEngine var1);
    }
}

