/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsModality;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentState;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceBotResponsesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UtteranceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UtteranceSpecification> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(UtteranceSpecification.getter(UtteranceSpecification::botAliasId)).setter(UtteranceSpecification.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UtteranceSpecification.getter(UtteranceSpecification::botVersion)).setter(UtteranceSpecification.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(UtteranceSpecification.getter(UtteranceSpecification::localeId)).setter(UtteranceSpecification.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UtteranceSpecification.getter(UtteranceSpecification::sessionId)).setter(UtteranceSpecification.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channel").getter(UtteranceSpecification.getter(UtteranceSpecification::channel)).setter(UtteranceSpecification.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(UtteranceSpecification.getter(UtteranceSpecification::modeAsString)).setter(UtteranceSpecification.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<Instant> CONVERSATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("conversationStartTime").getter(UtteranceSpecification.getter(UtteranceSpecification::conversationStartTime)).setter(UtteranceSpecification.setter(Builder::conversationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationStartTime").build()}).build();
    private static final SdkField<Instant> CONVERSATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("conversationEndTime").getter(UtteranceSpecification.getter(UtteranceSpecification::conversationEndTime)).setter(UtteranceSpecification.setter(Builder::conversationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationEndTime").build()}).build();
    private static final SdkField<String> UTTERANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("utterance").getter(UtteranceSpecification.getter(UtteranceSpecification::utterance)).setter(UtteranceSpecification.setter(Builder::utterance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterance").build()}).build();
    private static final SdkField<Instant> UTTERANCE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("utteranceTimestamp").getter(UtteranceSpecification.getter(UtteranceSpecification::utteranceTimestamp)).setter(UtteranceSpecification.setter(Builder::utteranceTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceTimestamp").build()}).build();
    private static final SdkField<Long> AUDIO_VOICE_DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("audioVoiceDurationMillis").getter(UtteranceSpecification.getter(UtteranceSpecification::audioVoiceDurationMillis)).setter(UtteranceSpecification.setter(Builder::audioVoiceDurationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioVoiceDurationMillis").build()}).build();
    private static final SdkField<Boolean> UTTERANCE_UNDERSTOOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("utteranceUnderstood").getter(UtteranceSpecification.getter(UtteranceSpecification::utteranceUnderstood)).setter(UtteranceSpecification.setter(Builder::utteranceUnderstood)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceUnderstood").build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputType").getter(UtteranceSpecification.getter(UtteranceSpecification::inputType)).setter(UtteranceSpecification.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputType").getter(UtteranceSpecification.getter(UtteranceSpecification::outputType)).setter(UtteranceSpecification.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()}).build();
    private static final SdkField<String> ASSOCIATED_INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedIntentName").getter(UtteranceSpecification.getter(UtteranceSpecification::associatedIntentName)).setter(UtteranceSpecification.setter(Builder::associatedIntentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedIntentName").build()}).build();
    private static final SdkField<String> ASSOCIATED_SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associatedSlotName").getter(UtteranceSpecification.getter(UtteranceSpecification::associatedSlotName)).setter(UtteranceSpecification.setter(Builder::associatedSlotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedSlotName").build()}).build();
    private static final SdkField<String> INTENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentState").getter(UtteranceSpecification.getter(UtteranceSpecification::intentStateAsString)).setter(UtteranceSpecification.setter(Builder::intentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentState").build()}).build();
    private static final SdkField<String> DIALOG_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dialogActionType").getter(UtteranceSpecification.getter(UtteranceSpecification::dialogActionType)).setter(UtteranceSpecification.setter(Builder::dialogActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogActionType").build()}).build();
    private static final SdkField<String> BOT_RESPONSE_AUDIO_VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botResponseAudioVoiceId").getter(UtteranceSpecification.getter(UtteranceSpecification::botResponseAudioVoiceId)).setter(UtteranceSpecification.setter(Builder::botResponseAudioVoiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botResponseAudioVoiceId").build()}).build();
    private static final SdkField<String> SLOTS_FILLED_IN_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotsFilledInSession").getter(UtteranceSpecification.getter(UtteranceSpecification::slotsFilledInSession)).setter(UtteranceSpecification.setter(Builder::slotsFilledInSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotsFilledInSession").build()}).build();
    private static final SdkField<String> UTTERANCE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("utteranceRequestId").getter(UtteranceSpecification.getter(UtteranceSpecification::utteranceRequestId)).setter(UtteranceSpecification.setter(Builder::utteranceRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceRequestId").build()}).build();
    private static final SdkField<List<UtteranceBotResponse>> BOT_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botResponses").getter(UtteranceSpecification.getter(UtteranceSpecification::botResponses)).setter(UtteranceSpecification.setter(Builder::botResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botResponses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtteranceBotResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, CHANNEL_FIELD, MODE_FIELD, CONVERSATION_START_TIME_FIELD, CONVERSATION_END_TIME_FIELD, UTTERANCE_FIELD, UTTERANCE_TIMESTAMP_FIELD, AUDIO_VOICE_DURATION_MILLIS_FIELD, UTTERANCE_UNDERSTOOD_FIELD, INPUT_TYPE_FIELD, OUTPUT_TYPE_FIELD, ASSOCIATED_INTENT_NAME_FIELD, ASSOCIATED_SLOT_NAME_FIELD, INTENT_STATE_FIELD, DIALOG_ACTION_TYPE_FIELD, BOT_RESPONSE_AUDIO_VOICE_ID_FIELD, SLOTS_FILLED_IN_SESSION_FIELD, UTTERANCE_REQUEST_ID_FIELD, BOT_RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botAliasId", BOT_ALIAS_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
            this.put("channel", CHANNEL_FIELD);
            this.put("mode", MODE_FIELD);
            this.put("conversationStartTime", CONVERSATION_START_TIME_FIELD);
            this.put("conversationEndTime", CONVERSATION_END_TIME_FIELD);
            this.put("utterance", UTTERANCE_FIELD);
            this.put("utteranceTimestamp", UTTERANCE_TIMESTAMP_FIELD);
            this.put("audioVoiceDurationMillis", AUDIO_VOICE_DURATION_MILLIS_FIELD);
            this.put("utteranceUnderstood", UTTERANCE_UNDERSTOOD_FIELD);
            this.put("inputType", INPUT_TYPE_FIELD);
            this.put("outputType", OUTPUT_TYPE_FIELD);
            this.put("associatedIntentName", ASSOCIATED_INTENT_NAME_FIELD);
            this.put("associatedSlotName", ASSOCIATED_SLOT_NAME_FIELD);
            this.put("intentState", INTENT_STATE_FIELD);
            this.put("dialogActionType", DIALOG_ACTION_TYPE_FIELD);
            this.put("botResponseAudioVoiceId", BOT_RESPONSE_AUDIO_VOICE_ID_FIELD);
            this.put("slotsFilledInSession", SLOTS_FILLED_IN_SESSION_FIELD);
            this.put("utteranceRequestId", UTTERANCE_REQUEST_ID_FIELD);
            this.put("botResponses", BOT_RESPONSES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String botAliasId;
    private final String botVersion;
    private final String localeId;
    private final String sessionId;
    private final String channel;
    private final String mode;
    private final Instant conversationStartTime;
    private final Instant conversationEndTime;
    private final String utterance;
    private final Instant utteranceTimestamp;
    private final Long audioVoiceDurationMillis;
    private final Boolean utteranceUnderstood;
    private final String inputType;
    private final String outputType;
    private final String associatedIntentName;
    private final String associatedSlotName;
    private final String intentState;
    private final String dialogActionType;
    private final String botResponseAudioVoiceId;
    private final String slotsFilledInSession;
    private final String utteranceRequestId;
    private final List<UtteranceBotResponse> botResponses;

    private UtteranceSpecification(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.channel = builder.channel;
        this.mode = builder.mode;
        this.conversationStartTime = builder.conversationStartTime;
        this.conversationEndTime = builder.conversationEndTime;
        this.utterance = builder.utterance;
        this.utteranceTimestamp = builder.utteranceTimestamp;
        this.audioVoiceDurationMillis = builder.audioVoiceDurationMillis;
        this.utteranceUnderstood = builder.utteranceUnderstood;
        this.inputType = builder.inputType;
        this.outputType = builder.outputType;
        this.associatedIntentName = builder.associatedIntentName;
        this.associatedSlotName = builder.associatedSlotName;
        this.intentState = builder.intentState;
        this.dialogActionType = builder.dialogActionType;
        this.botResponseAudioVoiceId = builder.botResponseAudioVoiceId;
        this.slotsFilledInSession = builder.slotsFilledInSession;
        this.utteranceRequestId = builder.utteranceRequestId;
        this.botResponses = builder.botResponses;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String channel() {
        return this.channel;
    }

    public final AnalyticsModality mode() {
        return AnalyticsModality.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Instant conversationStartTime() {
        return this.conversationStartTime;
    }

    public final Instant conversationEndTime() {
        return this.conversationEndTime;
    }

    public final String utterance() {
        return this.utterance;
    }

    public final Instant utteranceTimestamp() {
        return this.utteranceTimestamp;
    }

    public final Long audioVoiceDurationMillis() {
        return this.audioVoiceDurationMillis;
    }

    public final Boolean utteranceUnderstood() {
        return this.utteranceUnderstood;
    }

    public final String inputType() {
        return this.inputType;
    }

    public final String outputType() {
        return this.outputType;
    }

    public final String associatedIntentName() {
        return this.associatedIntentName;
    }

    public final String associatedSlotName() {
        return this.associatedSlotName;
    }

    public final IntentState intentState() {
        return IntentState.fromValue(this.intentState);
    }

    public final String intentStateAsString() {
        return this.intentState;
    }

    public final String dialogActionType() {
        return this.dialogActionType;
    }

    public final String botResponseAudioVoiceId() {
        return this.botResponseAudioVoiceId;
    }

    public final String slotsFilledInSession() {
        return this.slotsFilledInSession;
    }

    public final String utteranceRequestId() {
        return this.utteranceRequestId;
    }

    public final boolean hasBotResponses() {
        return this.botResponses != null && !(this.botResponses instanceof SdkAutoConstructList);
    }

    public final List<UtteranceBotResponse> botResponses() {
        return this.botResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.utterance());
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioVoiceDurationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceUnderstood());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputType());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputType());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedIntentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedSlotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogActionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.botResponseAudioVoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotsFilledInSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotResponses() ? this.botResponses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceSpecification)) {
            return false;
        }
        UtteranceSpecification other = (UtteranceSpecification)obj;
        return Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.channel(), other.channel()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.conversationStartTime(), other.conversationStartTime()) && Objects.equals(this.conversationEndTime(), other.conversationEndTime()) && Objects.equals(this.utterance(), other.utterance()) && Objects.equals(this.utteranceTimestamp(), other.utteranceTimestamp()) && Objects.equals(this.audioVoiceDurationMillis(), other.audioVoiceDurationMillis()) && Objects.equals(this.utteranceUnderstood(), other.utteranceUnderstood()) && Objects.equals(this.inputType(), other.inputType()) && Objects.equals(this.outputType(), other.outputType()) && Objects.equals(this.associatedIntentName(), other.associatedIntentName()) && Objects.equals(this.associatedSlotName(), other.associatedSlotName()) && Objects.equals(this.intentStateAsString(), other.intentStateAsString()) && Objects.equals(this.dialogActionType(), other.dialogActionType()) && Objects.equals(this.botResponseAudioVoiceId(), other.botResponseAudioVoiceId()) && Objects.equals(this.slotsFilledInSession(), other.slotsFilledInSession()) && Objects.equals(this.utteranceRequestId(), other.utteranceRequestId()) && this.hasBotResponses() == other.hasBotResponses() && Objects.equals(this.botResponses(), other.botResponses());
    }

    public final String toString() {
        return ToString.builder((String)"UtteranceSpecification").add("BotAliasId", (Object)this.botAliasId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("SessionId", (Object)this.sessionId()).add("Channel", (Object)this.channel()).add("Mode", (Object)this.modeAsString()).add("ConversationStartTime", (Object)this.conversationStartTime()).add("ConversationEndTime", (Object)this.conversationEndTime()).add("Utterance", (Object)this.utterance()).add("UtteranceTimestamp", (Object)this.utteranceTimestamp()).add("AudioVoiceDurationMillis", (Object)this.audioVoiceDurationMillis()).add("UtteranceUnderstood", (Object)this.utteranceUnderstood()).add("InputType", (Object)this.inputType()).add("OutputType", (Object)this.outputType()).add("AssociatedIntentName", (Object)this.associatedIntentName()).add("AssociatedSlotName", (Object)this.associatedSlotName()).add("IntentState", (Object)this.intentStateAsString()).add("DialogActionType", (Object)this.dialogActionType()).add("BotResponseAudioVoiceId", (Object)this.botResponseAudioVoiceId()).add("SlotsFilledInSession", (Object)this.slotsFilledInSession()).add("UtteranceRequestId", (Object)this.utteranceRequestId()).add("BotResponses", this.hasBotResponses() ? this.botResponses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "conversationStartTime": {
                return Optional.ofNullable(clazz.cast(this.conversationStartTime()));
            }
            case "conversationEndTime": {
                return Optional.ofNullable(clazz.cast(this.conversationEndTime()));
            }
            case "utterance": {
                return Optional.ofNullable(clazz.cast(this.utterance()));
            }
            case "utteranceTimestamp": {
                return Optional.ofNullable(clazz.cast(this.utteranceTimestamp()));
            }
            case "audioVoiceDurationMillis": {
                return Optional.ofNullable(clazz.cast(this.audioVoiceDurationMillis()));
            }
            case "utteranceUnderstood": {
                return Optional.ofNullable(clazz.cast(this.utteranceUnderstood()));
            }
            case "inputType": {
                return Optional.ofNullable(clazz.cast(this.inputType()));
            }
            case "outputType": {
                return Optional.ofNullable(clazz.cast(this.outputType()));
            }
            case "associatedIntentName": {
                return Optional.ofNullable(clazz.cast(this.associatedIntentName()));
            }
            case "associatedSlotName": {
                return Optional.ofNullable(clazz.cast(this.associatedSlotName()));
            }
            case "intentState": {
                return Optional.ofNullable(clazz.cast(this.intentStateAsString()));
            }
            case "dialogActionType": {
                return Optional.ofNullable(clazz.cast(this.dialogActionType()));
            }
            case "botResponseAudioVoiceId": {
                return Optional.ofNullable(clazz.cast(this.botResponseAudioVoiceId()));
            }
            case "slotsFilledInSession": {
                return Optional.ofNullable(clazz.cast(this.slotsFilledInSession()));
            }
            case "utteranceRequestId": {
                return Optional.ofNullable(clazz.cast(this.utteranceRequestId()));
            }
            case "botResponses": {
                return Optional.ofNullable(clazz.cast(this.botResponses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceSpecification, T> g) {
        return obj -> g.apply((UtteranceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botAliasId;
        private String botVersion;
        private String localeId;
        private String sessionId;
        private String channel;
        private String mode;
        private Instant conversationStartTime;
        private Instant conversationEndTime;
        private String utterance;
        private Instant utteranceTimestamp;
        private Long audioVoiceDurationMillis;
        private Boolean utteranceUnderstood;
        private String inputType;
        private String outputType;
        private String associatedIntentName;
        private String associatedSlotName;
        private String intentState;
        private String dialogActionType;
        private String botResponseAudioVoiceId;
        private String slotsFilledInSession;
        private String utteranceRequestId;
        private List<UtteranceBotResponse> botResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceSpecification model) {
            this.botAliasId(model.botAliasId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.sessionId(model.sessionId);
            this.channel(model.channel);
            this.mode(model.mode);
            this.conversationStartTime(model.conversationStartTime);
            this.conversationEndTime(model.conversationEndTime);
            this.utterance(model.utterance);
            this.utteranceTimestamp(model.utteranceTimestamp);
            this.audioVoiceDurationMillis(model.audioVoiceDurationMillis);
            this.utteranceUnderstood(model.utteranceUnderstood);
            this.inputType(model.inputType);
            this.outputType(model.outputType);
            this.associatedIntentName(model.associatedIntentName);
            this.associatedSlotName(model.associatedSlotName);
            this.intentState(model.intentState);
            this.dialogActionType(model.dialogActionType);
            this.botResponseAudioVoiceId(model.botResponseAudioVoiceId);
            this.slotsFilledInSession(model.slotsFilledInSession);
            this.utteranceRequestId(model.utteranceRequestId);
            this.botResponses(model.botResponses);
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AnalyticsModality mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Instant getConversationStartTime() {
            return this.conversationStartTime;
        }

        public final void setConversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
        }

        @Override
        public final Builder conversationStartTime(Instant conversationStartTime) {
            this.conversationStartTime = conversationStartTime;
            return this;
        }

        public final Instant getConversationEndTime() {
            return this.conversationEndTime;
        }

        public final void setConversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
        }

        @Override
        public final Builder conversationEndTime(Instant conversationEndTime) {
            this.conversationEndTime = conversationEndTime;
            return this;
        }

        public final String getUtterance() {
            return this.utterance;
        }

        public final void setUtterance(String utterance) {
            this.utterance = utterance;
        }

        @Override
        public final Builder utterance(String utterance) {
            this.utterance = utterance;
            return this;
        }

        public final Instant getUtteranceTimestamp() {
            return this.utteranceTimestamp;
        }

        public final void setUtteranceTimestamp(Instant utteranceTimestamp) {
            this.utteranceTimestamp = utteranceTimestamp;
        }

        @Override
        public final Builder utteranceTimestamp(Instant utteranceTimestamp) {
            this.utteranceTimestamp = utteranceTimestamp;
            return this;
        }

        public final Long getAudioVoiceDurationMillis() {
            return this.audioVoiceDurationMillis;
        }

        public final void setAudioVoiceDurationMillis(Long audioVoiceDurationMillis) {
            this.audioVoiceDurationMillis = audioVoiceDurationMillis;
        }

        @Override
        public final Builder audioVoiceDurationMillis(Long audioVoiceDurationMillis) {
            this.audioVoiceDurationMillis = audioVoiceDurationMillis;
            return this;
        }

        public final Boolean getUtteranceUnderstood() {
            return this.utteranceUnderstood;
        }

        public final void setUtteranceUnderstood(Boolean utteranceUnderstood) {
            this.utteranceUnderstood = utteranceUnderstood;
        }

        @Override
        public final Builder utteranceUnderstood(Boolean utteranceUnderstood) {
            this.utteranceUnderstood = utteranceUnderstood;
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public final String getAssociatedIntentName() {
            return this.associatedIntentName;
        }

        public final void setAssociatedIntentName(String associatedIntentName) {
            this.associatedIntentName = associatedIntentName;
        }

        @Override
        public final Builder associatedIntentName(String associatedIntentName) {
            this.associatedIntentName = associatedIntentName;
            return this;
        }

        public final String getAssociatedSlotName() {
            return this.associatedSlotName;
        }

        public final void setAssociatedSlotName(String associatedSlotName) {
            this.associatedSlotName = associatedSlotName;
        }

        @Override
        public final Builder associatedSlotName(String associatedSlotName) {
            this.associatedSlotName = associatedSlotName;
            return this;
        }

        public final String getIntentState() {
            return this.intentState;
        }

        public final void setIntentState(String intentState) {
            this.intentState = intentState;
        }

        @Override
        public final Builder intentState(String intentState) {
            this.intentState = intentState;
            return this;
        }

        @Override
        public final Builder intentState(IntentState intentState) {
            this.intentState(intentState == null ? null : intentState.toString());
            return this;
        }

        public final String getDialogActionType() {
            return this.dialogActionType;
        }

        public final void setDialogActionType(String dialogActionType) {
            this.dialogActionType = dialogActionType;
        }

        @Override
        public final Builder dialogActionType(String dialogActionType) {
            this.dialogActionType = dialogActionType;
            return this;
        }

        public final String getBotResponseAudioVoiceId() {
            return this.botResponseAudioVoiceId;
        }

        public final void setBotResponseAudioVoiceId(String botResponseAudioVoiceId) {
            this.botResponseAudioVoiceId = botResponseAudioVoiceId;
        }

        @Override
        public final Builder botResponseAudioVoiceId(String botResponseAudioVoiceId) {
            this.botResponseAudioVoiceId = botResponseAudioVoiceId;
            return this;
        }

        public final String getSlotsFilledInSession() {
            return this.slotsFilledInSession;
        }

        public final void setSlotsFilledInSession(String slotsFilledInSession) {
            this.slotsFilledInSession = slotsFilledInSession;
        }

        @Override
        public final Builder slotsFilledInSession(String slotsFilledInSession) {
            this.slotsFilledInSession = slotsFilledInSession;
            return this;
        }

        public final String getUtteranceRequestId() {
            return this.utteranceRequestId;
        }

        public final void setUtteranceRequestId(String utteranceRequestId) {
            this.utteranceRequestId = utteranceRequestId;
        }

        @Override
        public final Builder utteranceRequestId(String utteranceRequestId) {
            this.utteranceRequestId = utteranceRequestId;
            return this;
        }

        public final List<UtteranceBotResponse.Builder> getBotResponses() {
            List<UtteranceBotResponse.Builder> result = UtteranceBotResponsesCopier.copyToBuilder(this.botResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotResponses(Collection<UtteranceBotResponse.BuilderImpl> botResponses) {
            this.botResponses = UtteranceBotResponsesCopier.copyFromBuilder(botResponses);
        }

        @Override
        public final Builder botResponses(Collection<UtteranceBotResponse> botResponses) {
            this.botResponses = UtteranceBotResponsesCopier.copy(botResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botResponses(UtteranceBotResponse ... botResponses) {
            this.botResponses(Arrays.asList(botResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botResponses(Consumer<UtteranceBotResponse.Builder> ... botResponses) {
            this.botResponses(Stream.of(botResponses).map(c -> (UtteranceBotResponse)((UtteranceBotResponse.Builder)UtteranceBotResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UtteranceSpecification build() {
            return new UtteranceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UtteranceSpecification> {
        public Builder botAliasId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder sessionId(String var1);

        public Builder channel(String var1);

        public Builder mode(String var1);

        public Builder mode(AnalyticsModality var1);

        public Builder conversationStartTime(Instant var1);

        public Builder conversationEndTime(Instant var1);

        public Builder utterance(String var1);

        public Builder utteranceTimestamp(Instant var1);

        public Builder audioVoiceDurationMillis(Long var1);

        public Builder utteranceUnderstood(Boolean var1);

        public Builder inputType(String var1);

        public Builder outputType(String var1);

        public Builder associatedIntentName(String var1);

        public Builder associatedSlotName(String var1);

        public Builder intentState(String var1);

        public Builder intentState(IntentState var1);

        public Builder dialogActionType(String var1);

        public Builder botResponseAudioVoiceId(String var1);

        public Builder slotsFilledInSession(String var1);

        public Builder utteranceRequestId(String var1);

        public Builder botResponses(Collection<UtteranceBotResponse> var1);

        public Builder botResponses(UtteranceBotResponse ... var1);

        public Builder botResponses(Consumer<UtteranceBotResponse.Builder> ... var1);
    }
}

