/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext;
import software.amazon.awssdk.services.lexmodelsv2.model.ActiveContextListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.UserTurnIntentOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserTurnOutputSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserTurnOutputSpecification> {
    private static final SdkField<UserTurnIntentOutput> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intent").getter(UserTurnOutputSpecification.getter(UserTurnOutputSpecification::intent)).setter(UserTurnOutputSpecification.setter(Builder::intent)).constructor(UserTurnIntentOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()}).build();
    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeContexts").getter(UserTurnOutputSpecification.getter(UserTurnOutputSpecification::activeContexts)).setter(UserTurnOutputSpecification.setter(Builder::activeContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transcript").getter(UserTurnOutputSpecification.getter(UserTurnOutputSpecification::transcript)).setter(UserTurnOutputSpecification.setter(Builder::transcript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcript").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_FIELD, ACTIVE_CONTEXTS_FIELD, TRANSCRIPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("intent", INTENT_FIELD);
            this.put("activeContexts", ACTIVE_CONTEXTS_FIELD);
            this.put("transcript", TRANSCRIPT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final UserTurnIntentOutput intent;
    private final List<ActiveContext> activeContexts;
    private final String transcript;

    private UserTurnOutputSpecification(BuilderImpl builder) {
        this.intent = builder.intent;
        this.activeContexts = builder.activeContexts;
        this.transcript = builder.transcript;
    }

    public final UserTurnIntentOutput intent() {
        return this.intent;
    }

    public final boolean hasActiveContexts() {
        return this.activeContexts != null && !(this.activeContexts instanceof SdkAutoConstructList);
    }

    public final List<ActiveContext> activeContexts() {
        return this.activeContexts;
    }

    public final String transcript() {
        return this.transcript;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveContexts() ? this.activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnOutputSpecification)) {
            return false;
        }
        UserTurnOutputSpecification other = (UserTurnOutputSpecification)obj;
        return Objects.equals(this.intent(), other.intent()) && this.hasActiveContexts() == other.hasActiveContexts() && Objects.equals(this.activeContexts(), other.activeContexts()) && Objects.equals(this.transcript(), other.transcript());
    }

    public final String toString() {
        return ToString.builder((String)"UserTurnOutputSpecification").add("Intent", (Object)this.intent()).add("ActiveContexts", this.hasActiveContexts() ? this.activeContexts() : null).add("Transcript", (Object)this.transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intent": {
                return Optional.ofNullable(clazz.cast(this.intent()));
            }
            case "activeContexts": {
                return Optional.ofNullable(clazz.cast(this.activeContexts()));
            }
            case "transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnOutputSpecification, T> g) {
        return obj -> g.apply((UserTurnOutputSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserTurnIntentOutput intent;
        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();
        private String transcript;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnOutputSpecification model) {
            this.intent(model.intent);
            this.activeContexts(model.activeContexts);
            this.transcript(model.transcript);
        }

        public final UserTurnIntentOutput.Builder getIntent() {
            return this.intent != null ? this.intent.toBuilder() : null;
        }

        public final void setIntent(UserTurnIntentOutput.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(UserTurnIntentOutput intent) {
            this.intent = intent;
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext ... activeContexts) {
            this.activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder> ... activeContexts) {
            this.activeContexts(Stream.of(activeContexts).map(c -> (ActiveContext)((ActiveContext.Builder)ActiveContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTranscript() {
            return this.transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public UserTurnOutputSpecification build() {
            return new UserTurnOutputSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserTurnOutputSpecification> {
        public Builder intent(UserTurnIntentOutput var1);

        default public Builder intent(Consumer<UserTurnIntentOutput.Builder> intent) {
            return this.intent((UserTurnIntentOutput)((UserTurnIntentOutput.Builder)UserTurnIntentOutput.builder().applyMutation(intent)).build());
        }

        public Builder activeContexts(Collection<ActiveContext> var1);

        public Builder activeContexts(ActiveContext ... var1);

        public Builder activeContexts(Consumer<ActiveContext.Builder> ... var1);

        public Builder transcript(String var1);
    }
}

