/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotTypeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotTypeSummary> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeId").getter(SlotTypeSummary.getter(SlotTypeSummary::slotTypeId)).setter(SlotTypeSummary.setter(Builder::slotTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()}).build();
    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeName").getter(SlotTypeSummary.getter(SlotTypeSummary::slotTypeName)).setter(SlotTypeSummary.setter(Builder::slotTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SlotTypeSummary.getter(SlotTypeSummary::description)).setter(SlotTypeSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentSlotTypeSignature").getter(SlotTypeSummary.getter(SlotTypeSummary::parentSlotTypeSignature)).setter(SlotTypeSummary.setter(Builder::parentSlotTypeSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(SlotTypeSummary.getter(SlotTypeSummary::lastUpdatedDateTime)).setter(SlotTypeSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> SLOT_TYPE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeCategory").getter(SlotTypeSummary.getter(SlotTypeSummary::slotTypeCategoryAsString)).setter(SlotTypeSummary.setter(Builder::slotTypeCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD, SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD, LAST_UPDATED_DATE_TIME_FIELD, SLOT_TYPE_CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("slotTypeId", SLOT_TYPE_ID_FIELD);
            this.put("slotTypeName", SLOT_TYPE_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("parentSlotTypeSignature", PARENT_SLOT_TYPE_SIGNATURE_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
            this.put("slotTypeCategory", SLOT_TYPE_CATEGORY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String slotTypeId;
    private final String slotTypeName;
    private final String description;
    private final String parentSlotTypeSignature;
    private final Instant lastUpdatedDateTime;
    private final String slotTypeCategory;

    private SlotTypeSummary(BuilderImpl builder) {
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.slotTypeCategory = builder.slotTypeCategory;
    }

    public final String slotTypeId() {
        return this.slotTypeId;
    }

    public final String slotTypeName() {
        return this.slotTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final String parentSlotTypeSignature() {
        return this.parentSlotTypeSignature;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final SlotTypeCategory slotTypeCategory() {
        return SlotTypeCategory.fromValue(this.slotTypeCategory);
    }

    public final String slotTypeCategoryAsString() {
        return this.slotTypeCategory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeCategoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeSummary)) {
            return false;
        }
        SlotTypeSummary other = (SlotTypeSummary)obj;
        return Objects.equals(this.slotTypeId(), other.slotTypeId()) && Objects.equals(this.slotTypeName(), other.slotTypeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parentSlotTypeSignature(), other.parentSlotTypeSignature()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.slotTypeCategoryAsString(), other.slotTypeCategoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SlotTypeSummary").add("SlotTypeId", (Object)this.slotTypeId()).add("SlotTypeName", (Object)this.slotTypeName()).add("Description", (Object)this.description()).add("ParentSlotTypeSignature", (Object)this.parentSlotTypeSignature()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("SlotTypeCategory", (Object)this.slotTypeCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "slotTypeId": {
                return Optional.ofNullable(clazz.cast(this.slotTypeId()));
            }
            case "slotTypeName": {
                return Optional.ofNullable(clazz.cast(this.slotTypeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parentSlotTypeSignature": {
                return Optional.ofNullable(clazz.cast(this.parentSlotTypeSignature()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "slotTypeCategory": {
                return Optional.ofNullable(clazz.cast(this.slotTypeCategoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeSummary, T> g) {
        return obj -> g.apply((SlotTypeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String slotTypeId;
        private String slotTypeName;
        private String description;
        private String parentSlotTypeSignature;
        private Instant lastUpdatedDateTime;
        private String slotTypeCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeSummary model) {
            this.slotTypeId(model.slotTypeId);
            this.slotTypeName(model.slotTypeName);
            this.description(model.description);
            this.parentSlotTypeSignature(model.parentSlotTypeSignature);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.slotTypeCategory(model.slotTypeCategory);
        }

        public final String getSlotTypeId() {
            return this.slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final String getSlotTypeName() {
            return this.slotTypeName;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return this.parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getSlotTypeCategory() {
            return this.slotTypeCategory;
        }

        public final void setSlotTypeCategory(String slotTypeCategory) {
            this.slotTypeCategory = slotTypeCategory;
        }

        @Override
        public final Builder slotTypeCategory(String slotTypeCategory) {
            this.slotTypeCategory = slotTypeCategory;
            return this;
        }

        @Override
        public final Builder slotTypeCategory(SlotTypeCategory slotTypeCategory) {
            this.slotTypeCategory(slotTypeCategory == null ? null : slotTypeCategory.toString());
            return this;
        }

        public SlotTypeSummary build() {
            return new SlotTypeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotTypeSummary> {
        public Builder slotTypeId(String var1);

        public Builder slotTypeName(String var1);

        public Builder description(String var1);

        public Builder parentSlotTypeSignature(String var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder slotTypeCategory(String var1);

        public Builder slotTypeCategory(SlotTypeCategory var1);
    }
}

