/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FulfillmentStartResponseSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FulfillmentStartResponseSpecification> {
    private static final SdkField<Integer> DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("delayInSeconds").getter(FulfillmentStartResponseSpecification.getter(FulfillmentStartResponseSpecification::delayInSeconds)).setter(FulfillmentStartResponseSpecification.setter(Builder::delayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delayInSeconds").build()}).build();
    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messageGroups").getter(FulfillmentStartResponseSpecification.getter(FulfillmentStartResponseSpecification::messageGroups)).setter(FulfillmentStartResponseSpecification.setter(Builder::messageGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowInterrupt").getter(FulfillmentStartResponseSpecification.getter(FulfillmentStartResponseSpecification::allowInterrupt)).setter(FulfillmentStartResponseSpecification.setter(Builder::allowInterrupt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELAY_IN_SECONDS_FIELD, MESSAGE_GROUPS_FIELD, ALLOW_INTERRUPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("delayInSeconds", DELAY_IN_SECONDS_FIELD);
            this.put("messageGroups", MESSAGE_GROUPS_FIELD);
            this.put("allowInterrupt", ALLOW_INTERRUPT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer delayInSeconds;
    private final List<MessageGroup> messageGroups;
    private final Boolean allowInterrupt;

    private FulfillmentStartResponseSpecification(BuilderImpl builder) {
        this.delayInSeconds = builder.delayInSeconds;
        this.messageGroups = builder.messageGroups;
        this.allowInterrupt = builder.allowInterrupt;
    }

    public final Integer delayInSeconds() {
        return this.delayInSeconds;
    }

    public final boolean hasMessageGroups() {
        return this.messageGroups != null && !(this.messageGroups instanceof SdkAutoConstructList);
    }

    public final List<MessageGroup> messageGroups() {
        return this.messageGroups;
    }

    public final Boolean allowInterrupt() {
        return this.allowInterrupt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageGroups() ? this.messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowInterrupt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentStartResponseSpecification)) {
            return false;
        }
        FulfillmentStartResponseSpecification other = (FulfillmentStartResponseSpecification)obj;
        return Objects.equals(this.delayInSeconds(), other.delayInSeconds()) && this.hasMessageGroups() == other.hasMessageGroups() && Objects.equals(this.messageGroups(), other.messageGroups()) && Objects.equals(this.allowInterrupt(), other.allowInterrupt());
    }

    public final String toString() {
        return ToString.builder((String)"FulfillmentStartResponseSpecification").add("DelayInSeconds", (Object)this.delayInSeconds()).add("MessageGroups", this.hasMessageGroups() ? this.messageGroups() : null).add("AllowInterrupt", (Object)this.allowInterrupt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "delayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.delayInSeconds()));
            }
            case "messageGroups": {
                return Optional.ofNullable(clazz.cast(this.messageGroups()));
            }
            case "allowInterrupt": {
                return Optional.ofNullable(clazz.cast(this.allowInterrupt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentStartResponseSpecification, T> g) {
        return obj -> g.apply((FulfillmentStartResponseSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer delayInSeconds;
        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowInterrupt;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentStartResponseSpecification model) {
            this.delayInSeconds(model.delayInSeconds);
            this.messageGroups(model.messageGroups);
            this.allowInterrupt(model.allowInterrupt);
        }

        public final Integer getDelayInSeconds() {
            return this.delayInSeconds;
        }

        public final void setDelayInSeconds(Integer delayInSeconds) {
            this.delayInSeconds = delayInSeconds;
        }

        @Override
        public final Builder delayInSeconds(Integer delayInSeconds) {
            this.delayInSeconds = delayInSeconds;
            return this;
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup ... messageGroups) {
            this.messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder> ... messageGroups) {
            this.messageGroups(Stream.of(messageGroups).map(c -> (MessageGroup)((MessageGroup.Builder)MessageGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowInterrupt() {
            return this.allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        public FulfillmentStartResponseSpecification build() {
            return new FulfillmentStartResponseSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FulfillmentStartResponseSpecification> {
        public Builder delayInSeconds(Integer var1);

        public Builder messageGroups(Collection<MessageGroup> var1);

        public Builder messageGroups(MessageGroup ... var1);

        public Builder messageGroups(Consumer<MessageGroup.Builder> ... var1);

        public Builder allowInterrupt(Boolean var1);
    }
}

