/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportSummary> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(ExportSummary.getter(ExportSummary::exportId)).setter(ExportSummary.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(ExportSummary.getter(ExportSummary::resourceSpecification)).setter(ExportSummary.setter(Builder::resourceSpecification)).constructor(ExportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(ExportSummary.getter(ExportSummary::fileFormatAsString)).setter(ExportSummary.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportStatus").getter(ExportSummary.getter(ExportSummary::exportStatusAsString)).setter(ExportSummary.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(ExportSummary.getter(ExportSummary::creationDateTime)).setter(ExportSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(ExportSummary.getter(ExportSummary::lastUpdatedDateTime)).setter(ExportSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, FILE_FORMAT_FIELD, EXPORT_STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportId;
    private final ExportResourceSpecification resourceSpecification;
    private final String fileFormat;
    private final String exportStatus;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private ExportSummary(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.exportStatus = builder.exportStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final ExportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSummary)) {
            return false;
        }
        ExportSummary other = (ExportSummary)obj;
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExportSummary").add("ExportId", (Object)this.exportId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("FileFormat", (Object)this.fileFormatAsString()).add("ExportStatus", (Object)this.exportStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "exportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSummary, T> g) {
        return obj -> g.apply((ExportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportId;
        private ExportResourceSpecification resourceSpecification;
        private String fileFormat;
        private String exportStatus;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSummary model) {
            this.exportId(model.exportId);
            this.resourceSpecification(model.resourceSpecification);
            this.fileFormat(model.fileFormat);
            this.exportStatus(model.exportStatus);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public ExportSummary build() {
            return new ExportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportSummary> {
        public Builder exportId(String var1);

        public Builder resourceSpecification(ExportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ExportResourceSpecification)((ExportResourceSpecification.Builder)ExportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder fileFormat(String var1);

        public Builder fileFormat(ImportExportFileFormat var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

