/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotExportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyExportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetExportSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportResourceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportResourceSpecification> {
    private static final SdkField<BotExportSpecification> BOT_EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("botExportSpecification").getter(ExportResourceSpecification.getter(ExportResourceSpecification::botExportSpecification)).setter(ExportResourceSpecification.setter(Builder::botExportSpecification)).constructor(BotExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botExportSpecification").build()}).build();
    private static final SdkField<BotLocaleExportSpecification> BOT_LOCALE_EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("botLocaleExportSpecification").getter(ExportResourceSpecification.getter(ExportResourceSpecification::botLocaleExportSpecification)).setter(ExportResourceSpecification.setter(Builder::botLocaleExportSpecification)).constructor(BotLocaleExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleExportSpecification").build()}).build();
    private static final SdkField<CustomVocabularyExportSpecification> CUSTOM_VOCABULARY_EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customVocabularyExportSpecification").getter(ExportResourceSpecification.getter(ExportResourceSpecification::customVocabularyExportSpecification)).setter(ExportResourceSpecification.setter(Builder::customVocabularyExportSpecification)).constructor(CustomVocabularyExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customVocabularyExportSpecification").build()}).build();
    private static final SdkField<TestSetExportSpecification> TEST_SET_EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testSetExportSpecification").getter(ExportResourceSpecification.getter(ExportResourceSpecification::testSetExportSpecification)).setter(ExportResourceSpecification.setter(Builder::testSetExportSpecification)).constructor(TestSetExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetExportSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_EXPORT_SPECIFICATION_FIELD, BOT_LOCALE_EXPORT_SPECIFICATION_FIELD, CUSTOM_VOCABULARY_EXPORT_SPECIFICATION_FIELD, TEST_SET_EXPORT_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportResourceSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BotExportSpecification botExportSpecification;
    private final BotLocaleExportSpecification botLocaleExportSpecification;
    private final CustomVocabularyExportSpecification customVocabularyExportSpecification;
    private final TestSetExportSpecification testSetExportSpecification;

    private ExportResourceSpecification(BuilderImpl builder) {
        this.botExportSpecification = builder.botExportSpecification;
        this.botLocaleExportSpecification = builder.botLocaleExportSpecification;
        this.customVocabularyExportSpecification = builder.customVocabularyExportSpecification;
        this.testSetExportSpecification = builder.testSetExportSpecification;
    }

    public final BotExportSpecification botExportSpecification() {
        return this.botExportSpecification;
    }

    public final BotLocaleExportSpecification botLocaleExportSpecification() {
        return this.botLocaleExportSpecification;
    }

    public final CustomVocabularyExportSpecification customVocabularyExportSpecification() {
        return this.customVocabularyExportSpecification;
    }

    public final TestSetExportSpecification testSetExportSpecification() {
        return this.testSetExportSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botExportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleExportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customVocabularyExportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetExportSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportResourceSpecification)) {
            return false;
        }
        ExportResourceSpecification other = (ExportResourceSpecification)obj;
        return Objects.equals(this.botExportSpecification(), other.botExportSpecification()) && Objects.equals(this.botLocaleExportSpecification(), other.botLocaleExportSpecification()) && Objects.equals(this.customVocabularyExportSpecification(), other.customVocabularyExportSpecification()) && Objects.equals(this.testSetExportSpecification(), other.testSetExportSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ExportResourceSpecification").add("BotExportSpecification", (Object)this.botExportSpecification()).add("BotLocaleExportSpecification", (Object)this.botLocaleExportSpecification()).add("CustomVocabularyExportSpecification", (Object)this.customVocabularyExportSpecification()).add("TestSetExportSpecification", (Object)this.testSetExportSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.botExportSpecification()));
            }
            case "botLocaleExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.botLocaleExportSpecification()));
            }
            case "customVocabularyExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.customVocabularyExportSpecification()));
            }
            case "testSetExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.testSetExportSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botExportSpecification", BOT_EXPORT_SPECIFICATION_FIELD);
        map.put("botLocaleExportSpecification", BOT_LOCALE_EXPORT_SPECIFICATION_FIELD);
        map.put("customVocabularyExportSpecification", CUSTOM_VOCABULARY_EXPORT_SPECIFICATION_FIELD);
        map.put("testSetExportSpecification", TEST_SET_EXPORT_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportResourceSpecification, T> g) {
        return obj -> g.apply((ExportResourceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BotExportSpecification botExportSpecification;
        private BotLocaleExportSpecification botLocaleExportSpecification;
        private CustomVocabularyExportSpecification customVocabularyExportSpecification;
        private TestSetExportSpecification testSetExportSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportResourceSpecification model) {
            this.botExportSpecification(model.botExportSpecification);
            this.botLocaleExportSpecification(model.botLocaleExportSpecification);
            this.customVocabularyExportSpecification(model.customVocabularyExportSpecification);
            this.testSetExportSpecification(model.testSetExportSpecification);
        }

        public final BotExportSpecification.Builder getBotExportSpecification() {
            return this.botExportSpecification != null ? this.botExportSpecification.toBuilder() : null;
        }

        public final void setBotExportSpecification(BotExportSpecification.BuilderImpl botExportSpecification) {
            this.botExportSpecification = botExportSpecification != null ? botExportSpecification.build() : null;
        }

        @Override
        public final Builder botExportSpecification(BotExportSpecification botExportSpecification) {
            this.botExportSpecification = botExportSpecification;
            return this;
        }

        public final BotLocaleExportSpecification.Builder getBotLocaleExportSpecification() {
            return this.botLocaleExportSpecification != null ? this.botLocaleExportSpecification.toBuilder() : null;
        }

        public final void setBotLocaleExportSpecification(BotLocaleExportSpecification.BuilderImpl botLocaleExportSpecification) {
            this.botLocaleExportSpecification = botLocaleExportSpecification != null ? botLocaleExportSpecification.build() : null;
        }

        @Override
        public final Builder botLocaleExportSpecification(BotLocaleExportSpecification botLocaleExportSpecification) {
            this.botLocaleExportSpecification = botLocaleExportSpecification;
            return this;
        }

        public final CustomVocabularyExportSpecification.Builder getCustomVocabularyExportSpecification() {
            return this.customVocabularyExportSpecification != null ? this.customVocabularyExportSpecification.toBuilder() : null;
        }

        public final void setCustomVocabularyExportSpecification(CustomVocabularyExportSpecification.BuilderImpl customVocabularyExportSpecification) {
            this.customVocabularyExportSpecification = customVocabularyExportSpecification != null ? customVocabularyExportSpecification.build() : null;
        }

        @Override
        public final Builder customVocabularyExportSpecification(CustomVocabularyExportSpecification customVocabularyExportSpecification) {
            this.customVocabularyExportSpecification = customVocabularyExportSpecification;
            return this;
        }

        public final TestSetExportSpecification.Builder getTestSetExportSpecification() {
            return this.testSetExportSpecification != null ? this.testSetExportSpecification.toBuilder() : null;
        }

        public final void setTestSetExportSpecification(TestSetExportSpecification.BuilderImpl testSetExportSpecification) {
            this.testSetExportSpecification = testSetExportSpecification != null ? testSetExportSpecification.build() : null;
        }

        @Override
        public final Builder testSetExportSpecification(TestSetExportSpecification testSetExportSpecification) {
            this.testSetExportSpecification = testSetExportSpecification;
            return this;
        }

        public ExportResourceSpecification build() {
            return new ExportResourceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportResourceSpecification> {
        public Builder botExportSpecification(BotExportSpecification var1);

        default public Builder botExportSpecification(Consumer<BotExportSpecification.Builder> botExportSpecification) {
            return this.botExportSpecification((BotExportSpecification)((BotExportSpecification.Builder)BotExportSpecification.builder().applyMutation(botExportSpecification)).build());
        }

        public Builder botLocaleExportSpecification(BotLocaleExportSpecification var1);

        default public Builder botLocaleExportSpecification(Consumer<BotLocaleExportSpecification.Builder> botLocaleExportSpecification) {
            return this.botLocaleExportSpecification((BotLocaleExportSpecification)((BotLocaleExportSpecification.Builder)BotLocaleExportSpecification.builder().applyMutation(botLocaleExportSpecification)).build());
        }

        public Builder customVocabularyExportSpecification(CustomVocabularyExportSpecification var1);

        default public Builder customVocabularyExportSpecification(Consumer<CustomVocabularyExportSpecification.Builder> customVocabularyExportSpecification) {
            return this.customVocabularyExportSpecification((CustomVocabularyExportSpecification)((CustomVocabularyExportSpecification.Builder)CustomVocabularyExportSpecification.builder().applyMutation(customVocabularyExportSpecification)).build());
        }

        public Builder testSetExportSpecification(TestSetExportSpecification var1);

        default public Builder testSetExportSpecification(Consumer<TestSetExportSpecification.Builder> testSetExportSpecification) {
            return this.testSetExportSpecification((TestSetExportSpecification)((TestSetExportSpecification.Builder)TestSetExportSpecification.builder().applyMutation(testSetExportSpecification)).build());
        }
    }
}

